/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.stopconsolidation;

import com.csvreader.CsvReader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.BooleanUtils;
import org.opentripplanner.ext.stopconsolidation.model.ConsolidatedStopGroup;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class StopConsolidationParser {
    public static List<ConsolidatedStopGroup> parseGroups(InputStream is) {
        try {
            CsvReader reader = new CsvReader(is, StandardCharsets.UTF_8);
            reader.setDelimiter(',');
            reader.readHeaders();
            ArrayList<StopGroupEntry> entries = new ArrayList<StopGroupEntry>();
            while (reader.readRecord()) {
                String id = reader.get("stop_group_id");
                String feedId = reader.get("feed_id");
                String stopId = reader.get("stop_id");
                boolean isPrimary = BooleanUtils.toBoolean((int)Integer.parseInt(reader.get("is_primary")));
                StopGroupEntry entry = new StopGroupEntry(id, new FeedScopedId(feedId, stopId), isPrimary);
                entries.add(entry);
            }
            ImmutableListMultimap groups = (ImmutableListMultimap)entries.stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(x -> x.groupId, Stream::of));
            return groups.keys().stream().map(key -> {
                ImmutableList group = groups.get(key);
                FeedScopedId primaryId = group.stream().filter((Predicate<StopGroupEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$parseGroups$1(org.opentripplanner.ext.stopconsolidation.StopConsolidationParser$StopGroupEntry ), (Lorg/opentripplanner/ext/stopconsolidation/StopConsolidationParser$StopGroupEntry;)Z)()).findAny().orElseThrow().stopId;
                Set<FeedScopedId> secondaries = group.stream().filter(e -> !e.isPrimary).map(e -> e.stopId).collect(Collectors.toSet());
                return new ConsolidatedStopGroup(primaryId, secondaries);
            }).distinct().toList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ boolean lambda$parseGroups$1(StopGroupEntry e) {
        return e.isPrimary;
    }

    private record StopGroupEntry(String groupId, FeedScopedId stopId, boolean isPrimary) {
    }
}

