/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.stopconsolidation;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationParser;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.ext.stopconsolidation.internal.DefaultStopConsolidationService;
import org.opentripplanner.ext.stopconsolidation.model.ConsolidatedStopGroup;
import org.opentripplanner.ext.stopconsolidation.model.StopReplacement;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.service.TimetableRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopConsolidationModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(StopConsolidationModule.class);
    private final StopConsolidationRepository repository;
    private final TimetableRepository timetableRepository;
    private final Collection<ConsolidatedStopGroup> groups;

    public StopConsolidationModule(TimetableRepository timetableRepository, StopConsolidationRepository repository, Collection<ConsolidatedStopGroup> groups) {
        this.timetableRepository = Objects.requireNonNull(timetableRepository);
        this.repository = Objects.requireNonNull(repository);
        this.groups = Objects.requireNonNull(groups);
    }

    @Override
    public void buildGraph() {
        this.repository.addGroups(this.groups);
        DefaultStopConsolidationService service = new DefaultStopConsolidationService(this.repository, this.timetableRepository);
        List<FeedScopedId> stopsToReplace = service.secondaryStops();
        List<StopReplacement> replacements = service.replacements();
        this.timetableRepository.getAllTripPatterns().stream().filter(pattern -> pattern.containsAnyStopId(stopsToReplace)).forEach(pattern -> {
            LOG.info("Replacing stop(s) in pattern {}", pattern);
            TripPattern modifiedPattern = this.modifyStopsInPattern((TripPattern)pattern, replacements);
            this.timetableRepository.addTripPattern(modifiedPattern.getId(), modifiedPattern);
        });
    }

    private TripPattern modifyStopsInPattern(TripPattern pattern, List<StopReplacement> replacements) {
        StopPattern.StopPatternBuilder updatedStopPattern = pattern.copyPlannedStopPattern();
        replacements.forEach(r -> updatedStopPattern.replaceStop(r.secondary(), r.primary()));
        return (TripPattern)pattern.copy().withStopPattern(updatedStopPattern.build()).build();
    }

    public static StopConsolidationModule of(TimetableRepository timetableRepository, StopConsolidationRepository repo, DataSource ds) {
        StopConsolidationModule stopConsolidationModule;
        block8: {
            LOG.info("Reading stop consolidation information from '{}'", (Object)ds);
            InputStream inputStream = ds.asInputStream();
            try {
                List<ConsolidatedStopGroup> groups = StopConsolidationParser.parseGroups(inputStream);
                stopConsolidationModule = new StopConsolidationModule(timetableRepository, repo, groups);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return stopConsolidationModule;
    }
}

