/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.stopconsolidation;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.ext.stopconsolidation.model.ConsolidatedStopLeg;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItineraryBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryDecorator;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.StopLocation;

public class DecorateConsolidatedStopNames
implements ItineraryDecorator {
    private static final int MAX_INTRA_STOP_WALK_DISTANCE_METERS = 15;
    private final StopConsolidationService service;

    public DecorateConsolidatedStopNames(StopConsolidationService service) {
        this.service = Objects.requireNonNull(service);
    }

    @Override
    public Itinerary decorate(Itinerary itinerary) {
        ItineraryBuilder builder = itinerary.copyOf();
        this.replaceConsolidatedStops(builder);
        this.removeShortWalkLegs(builder);
        return builder.build();
    }

    private void replaceConsolidatedStops(ItineraryBuilder builder) {
        builder.transformTransitLegs(leg -> {
            ScheduledTransitLeg stl;
            if (leg instanceof ScheduledTransitLeg && this.needsToRenameStops(stl = (ScheduledTransitLeg)leg)) {
                Agency agency = leg.agency();
                StopLocation from = this.service.primaryStop(stl.from().stop.getId()).orElse(stl.from().stop);
                StopLocation to = this.service.agencySpecificStop(stl.to().stop, agency);
                return ConsolidatedStopLeg.of(stl).withFrom(from).withTo(to).build();
            }
            return leg;
        });
    }

    private void removeShortWalkLegs(ItineraryBuilder builder) {
        ArrayList<Leg> legs = new ArrayList<Leg>(builder.legs());
        Leg first = legs.getFirst();
        if (this.service.isPartOfConsolidatedStop(first.to().stop) && DecorateConsolidatedStopNames.isShortWalkLeg(first)) {
            legs.removeFirst();
        }
        Leg last = legs.getLast();
        if (this.service.isPartOfConsolidatedStop(last.from().stop) && DecorateConsolidatedStopNames.isShortWalkLeg(last)) {
            legs.removeLast();
        }
        List<Leg> filteredLegs = legs.stream().filter(l -> !this.isTransferWithinConsolidatedStop((Leg)l)).toList();
        builder.withLegs(filteredLegs);
    }

    private boolean isTransferWithinConsolidatedStop(Leg l) {
        return DecorateConsolidatedStopNames.isShortWalkLeg(l) && this.service.isPartOfConsolidatedStop(l.from().stop) && this.service.isPartOfConsolidatedStop(l.to().stop);
    }

    private static boolean isShortWalkLeg(Leg leg) {
        return leg.isWalkingLeg() && leg.distanceMeters() < 15.0;
    }

    private boolean needsToRenameStops(ScheduledTransitLeg stl) {
        return this.service.isSecondaryStop(stl.from().stop) || this.service.isPrimaryStop(stl.to().stop);
    }
}

