/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.sorlandsbanen;

import java.util.Collection;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.opentripplanner.ext.sorlandsbanen.CoachCostCalculator;
import org.opentripplanner.ext.sorlandsbanen.MergePaths;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.raptor.spi.ExtraMcRouterSearch;
import org.opentripplanner.raptor.spi.RaptorTransitDataProvider;
import org.opentripplanner.routing.algorithm.raptoradapter.router.street.AccessEgresses;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransitData;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitData;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;

public class SorlandsbanenNorwayService {
    private static final double SOUTH_BORDER_LIMIT = 59.1;
    private static final int MIN_DISTANCE_LIMIT = 120000;

    @Nullable
    public ExtraMcRouterSearch<TripSchedule> createExtraMcRouterSearch(RouteRequest request, AccessEgresses accessEgresses, RaptorTransitData raptorTransitData) {
        WgsCoordinate from = SorlandsbanenNorwayService.findStopCoordinate(request.from(), accessEgresses.getAccesses(), raptorTransitData);
        WgsCoordinate to = SorlandsbanenNorwayService.findStopCoordinate(request.to(), accessEgresses.getEgresses(), raptorTransitData);
        if (from.isNorthOf(59.1) && to.isNorthOf(59.1)) {
            return null;
        }
        double distance = from.distanceTo(to);
        if (distance < 120000.0) {
            return null;
        }
        return new ExtraMcRouterSearch<TripSchedule>(this){

            public RaptorTransitDataProvider<TripSchedule> createTransitDataAlternativeSearch(RaptorTransitDataProvider<TripSchedule> transitDataMainSearch) {
                return new RaptorRoutingRequestTransitData((RaptorRoutingRequestTransitData)transitDataMainSearch, new CoachCostCalculator<TripSchedule>(transitDataMainSearch.multiCriteriaCostCalculator()));
            }

            public BiFunction<Collection<RaptorPath<TripSchedule>>, Collection<RaptorPath<TripSchedule>>, Collection<RaptorPath<TripSchedule>>> merger() {
                return new MergePaths<TripSchedule>();
            }
        };
    }

    private static WgsCoordinate findStopCoordinate(GenericLocation location, Collection<? extends RoutingAccessEgress> accessEgress, RaptorTransitData raptorTransitData) {
        if (location.lat != null) {
            return new WgsCoordinate(location.lat, location.lng);
        }
        StopLocation firstStop = null;
        for (RoutingAccessEgress routingAccessEgress : accessEgress) {
            StopLocation stop = raptorTransitData.getStopByIndex(routingAccessEgress.stop());
            if (stop.getId().equals(location.stopId)) {
                return stop.getCoordinate();
            }
            if (SorlandsbanenNorwayService.idIsParentStation(stop, location.stopId)) {
                return stop.getParentStation().getCoordinate();
            }
            if (firstStop != null) continue;
            firstStop = stop;
        }
        return firstStop.getCoordinate();
    }

    private static boolean idIsParentStation(StopLocation stop, FeedScopedId pId) {
        return stop.getParentStation() != null && stop.getParentStation().getId().equals(pId);
    }
}

