/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.sorlandsbanen;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.opentripplanner.ext.sorlandsbanen.PathKey;
import org.opentripplanner.raptor.api.model.RaptorTripSchedule;
import org.opentripplanner.raptor.api.path.PathLeg;
import org.opentripplanner.raptor.api.path.RaptorPath;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripScheduleWithOffset;
import org.opentripplanner.transit.model.basic.TransitMode;

class MergePaths<T extends RaptorTripSchedule>
implements BiFunction<Collection<RaptorPath<T>>, Collection<RaptorPath<T>>, Collection<RaptorPath<T>>> {
    MergePaths() {
    }

    @Override
    public Collection<RaptorPath<T>> apply(Collection<RaptorPath<T>> main, Collection<RaptorPath<T>> alternatives) {
        HashMap<PathKey, RaptorPath<T>> result = new HashMap<PathKey, RaptorPath<T>>();
        this.addAllToMap(result, main);
        this.addRailToMap(result, alternatives);
        return result.values();
    }

    private void addAllToMap(Map<PathKey, RaptorPath<T>> map, Collection<RaptorPath<T>> paths) {
        for (RaptorPath<T> it : paths) {
            map.put(new PathKey(it), it);
        }
    }

    private void addRailToMap(Map<PathKey, RaptorPath<T>> map, Collection<RaptorPath<T>> paths) {
        for (RaptorPath it : paths) {
            if (!MergePaths.hasRail(it)) continue;
            map.computeIfAbsent(new PathKey(it), k -> it);
        }
    }

    private static boolean hasRail(RaptorPath<?> path) {
        return path.legStream().filter(PathLeg::isTransitLeg).anyMatch(leg -> {
            TripScheduleWithOffset trip = (TripScheduleWithOffset)leg.asTransitLeg().trip();
            TransitMode mode = trip.getOriginalTripPattern().getMode();
            return mode == TransitMode.RAIL;
        });
    }
}

