/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.sorlandsbanen;

import org.opentripplanner.raptor.api.model.RaptorAccessEgress;
import org.opentripplanner.raptor.api.model.RaptorCostConverter;
import org.opentripplanner.raptor.api.model.RaptorTransferConstraint;
import org.opentripplanner.raptor.spi.RaptorCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.transit.model.basic.TransitMode;

class CoachCostCalculator<T extends TripSchedule>
implements RaptorCostCalculator<T> {
    private static final int EXTRA_RELUCTANCE_ON_COACH = RaptorCostConverter.toRaptorCost((double)0.6);
    private final RaptorCostCalculator<T> delegate;

    CoachCostCalculator(RaptorCostCalculator<T> delegate) {
        this.delegate = delegate;
    }

    public int boardingCost(boolean firstBoarding, int prevArrivalTime, int boardStop, int boardTime, T trip, RaptorTransferConstraint transferConstraints) {
        return this.delegate.boardingCost(firstBoarding, prevArrivalTime, boardStop, boardTime, trip, transferConstraints);
    }

    public int onTripRelativeRidingCost(int boardTime, T tripScheduledBoarded) {
        return this.delegate.onTripRelativeRidingCost(boardTime, tripScheduledBoarded);
    }

    public int transitArrivalCost(int boardCost, int alightSlack, int transitTime, T trip, int toStop) {
        int cost = this.delegate.transitArrivalCost(boardCost, alightSlack, transitTime, trip, toStop);
        if (trip.transitReluctanceFactorIndex() == TransitMode.COACH.ordinal()) {
            cost += transitTime * EXTRA_RELUCTANCE_ON_COACH;
        }
        return cost;
    }

    public int waitCost(int waitTimeInSeconds) {
        return this.delegate.waitCost(waitTimeInSeconds);
    }

    public int calculateRemainingMinCost(int minTravelTime, int minNumTransfers, int fromStop) {
        return this.delegate.calculateRemainingMinCost(minTravelTime, minNumTransfers, fromStop);
    }

    public int costEgress(RaptorAccessEgress egress) {
        return this.delegate.costEgress(egress);
    }
}

