/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater.azure;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.hc.core5.net.URIBuilder;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureUpdaterParameters;

public class SiriAzureSXUpdaterParameters
extends SiriAzureUpdaterParameters {
    private LocalDate fromDateTime;
    private LocalDate toDateTime;

    public SiriAzureSXUpdaterParameters() {
        super("siri-azure-sx-updater");
    }

    public LocalDate getFromDateTime() {
        return this.fromDateTime;
    }

    public void setFromDateTime(LocalDate fromDateTime) {
        this.fromDateTime = fromDateTime;
    }

    public LocalDate getToDateTime() {
        return this.toDateTime;
    }

    public void setToDateTime(LocalDate toDateTime) {
        this.toDateTime = toDateTime;
    }

    @Override
    public Optional<URI> buildDataInitializationUrl() throws URISyntaxException {
        String url = this.getDataInitializationUrl();
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new URIBuilder(url).addParameter("publishFromDateTime", this.fromDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE)).addParameter("publishToDateTime", this.toDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE)).build());
    }
}

