/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater.azure;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureMessageHandler;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureSXUpdaterParameters;
import org.opentripplanner.routing.impl.TransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.updater.alert.siri.SiriAlertsUpdateHandler;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.ServiceDelivery;

public class SiriAzureSXUpdater
implements SiriAzureMessageHandler {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final SiriAlertsUpdateHandler updateHandler;
    private final TransitAlertService transitAlertService;
    private WriteToGraphCallback saveResultOnGraph;

    public SiriAzureSXUpdater(SiriAzureSXUpdaterParameters config, TimetableRepository timetableRepository) {
        this.transitAlertService = new TransitAlertServiceImpl(timetableRepository);
        this.updateHandler = new SiriAlertsUpdateHandler(config.feedId(), this.transitAlertService, Duration.ZERO);
    }

    @Override
    public void setup(WriteToGraphCallback writeToGraphCallback) {
        this.saveResultOnGraph = writeToGraphCallback;
    }

    @Override
    @Nullable
    public Future<?> handleMessage(ServiceDelivery serviceDelivery, String messageId) {
        List sxDeliveries = serviceDelivery.getSituationExchangeDeliveries();
        if (sxDeliveries == null || sxDeliveries.isEmpty()) {
            this.LOG.info("Empty Siri SX message {}", (Object)messageId);
            return null;
        }
        return this.saveResultOnGraph.execute(context -> this.updateHandler.update(serviceDelivery, context));
    }

    public TransitAlertService getTransitAlertService() {
        return this.transitAlertService;
    }
}

