/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater.azure;

import com.azure.core.amqp.implementation.ConnectionStringProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.hc.core5.net.URIBuilder;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureUpdaterParameters;
import org.opentripplanner.updater.trip.UrlUpdaterParameters;

public class SiriAzureETUpdaterParameters
extends SiriAzureUpdaterParameters
implements UrlUpdaterParameters {
    private LocalDate fromDateTime;

    public SiriAzureETUpdaterParameters() {
        super("siri-azure-et-updater");
    }

    public LocalDate getFromDateTime() {
        return this.fromDateTime;
    }

    public void setFromDateTime(LocalDate fromDateTime) {
        this.fromDateTime = fromDateTime;
    }

    @Override
    public String url() {
        if (this.getFullyQualifiedNamespace() != null) {
            return this.getFullyQualifiedNamespace();
        }
        if (this.getServiceBusUrl() != null) {
            try {
                return new ConnectionStringProperties(this.getServiceBusUrl()).getEndpoint().toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "unknown";
    }

    @Override
    public Optional<URI> buildDataInitializationUrl() throws URISyntaxException {
        String url = this.getDataInitializationUrl();
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new URIBuilder(url).addParameter("fromDateTime", this.fromDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE)).build());
    }
}

