/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing.service.oauth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.ridehailing.service.oauth.CachedOAuthToken;
import org.opentripplanner.ext.ridehailing.service.oauth.OAuthService;
import org.opentripplanner.framework.json.ObjectMappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingOAuthService
implements OAuthService {
    private static final ObjectMapper MAPPER = ObjectMappers.ignoringExtraFields();
    private static final Logger LOG = LoggerFactory.getLogger(RideHailingService.class);
    private CachedOAuthToken cachedToken = CachedOAuthToken.empty();

    @Override
    public String getToken() throws IOException {
        if (this.cachedToken.isExpired()) {
            try {
                HttpRequest request = this.oauthTokenRequest();
                LOG.info("Requesting new {} access token", (Object)request.uri());
                HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    LOG.error("Error fetching OAuth token from {}. Response: {}", (Object)request.uri(), (Object)response.body());
                    throw new IOException("Could not fetch OAuth token from %s".formatted(request.uri()));
                }
                SerializedOAuthToken token = (SerializedOAuthToken)MAPPER.readValue(response.body(), SerializedOAuthToken.class);
                this.cachedToken = new CachedOAuthToken(token);
                LOG.info("Received new access token from URL {}", (Object)request.uri());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        return this.cachedToken.value;
    }

    protected abstract HttpRequest oauthTokenRequest();

    public record SerializedOAuthToken(String access_token, long expires_in) {
    }
}

