/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing.service.oauth;

import java.time.Duration;
import java.time.Instant;
import org.opentripplanner.ext.ridehailing.service.oauth.CachingOAuthService;

public class CachedOAuthToken {
    public final String value;
    private Instant tokenExpirationTime;

    private CachedOAuthToken() {
        this.value = null;
    }

    public static CachedOAuthToken empty() {
        return new CachedOAuthToken();
    }

    public CachedOAuthToken(CachingOAuthService.SerializedOAuthToken token) {
        this.value = token.access_token();
        this.tokenExpirationTime = Instant.now().plus(Duration.ofSeconds(token.expires_in()).minusMinutes(1L));
    }

    public boolean isExpired() {
        return this.tokenExpirationTime == null || Instant.now().isAfter(this.tokenExpirationTime);
    }
}

