/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing;

import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opentripplanner.ext.ridehailing.RideHailingAccessAdapter;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.ridehailing.model.ArrivalTime;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.transit.model.framework.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RideHailingAccessShifter {
    private static final Logger LOG = LoggerFactory.getLogger(RideHailingAccessShifter.class);
    private static final Duration MAX_DURATION_FROM_NOW = Duration.ofMinutes(30L);

    public static List<RoutingAccessEgress> shiftAccesses(boolean isAccess, List<RoutingAccessEgress> results, List<RideHailingService> services, RouteRequest request, Instant now) {
        return results.stream().map(ae -> {
            if (isAccess && ae.getLastState().containsModeCar()) {
                Result<Duration, Error> duration = RideHailingAccessShifter.fetchArrivalDelay(services, request, now);
                if (duration.isSuccess()) {
                    return new RideHailingAccessAdapter((RoutingAccessEgress)ae, duration.successValue());
                }
                return null;
            }
            return ae;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static Result<Duration, Error> arrivalDelay(RouteRequest req, List<RideHailingService> services, Instant now) {
        if (RideHailingAccessShifter.shouldShift(req, now)) {
            return RideHailingAccessShifter.shiftTime(req, services, now);
        }
        return Result.success(Duration.ZERO);
    }

    private static Result<Duration, Error> fetchArrivalDelay(List<RideHailingService> services, RouteRequest request, Instant now) {
        if (RideHailingAccessShifter.shouldShift(request, Instant.now())) {
            Result<Duration, Error> shiftingResult = RideHailingAccessShifter.arrivalDelay(request, services, now);
            if (shiftingResult.isSuccess()) {
                return Result.success(shiftingResult.successValue());
            }
            LOG.error("Could not fetch arrival time for car hailing service: {}", (Object)shiftingResult.failureValue());
            return Result.failure(Error.TECHNICAL_ERROR);
        }
        return Result.success(Duration.ZERO);
    }

    private static boolean shouldShift(RouteRequest req, Instant now) {
        return req.journey().modes().accessMode == StreetMode.CAR_HAILING && req.dateTime().isBefore(now.plus(MAX_DURATION_FROM_NOW)) && !req.arriveBy();
    }

    private static Result<Duration, Error> shiftTime(RouteRequest req, List<RideHailingService> services, Instant now) {
        try {
            RideHailingService service = services.get(0);
            Optional<ArrivalTime> arrivalTimeOpt = service.arrivalTimes(new WgsCoordinate(req.from().getCoordinate()), req.journey().wheelchair()).stream().min(Comparator.comparing(ArrivalTime::duration));
            if (arrivalTimeOpt.isPresent()) {
                ArrivalTime earliestArrival = arrivalTimeOpt.get();
                Duration duration = earliestArrival.duration().minus(Duration.between(now, req.dateTime()));
                if (duration.isNegative()) {
                    duration = Duration.ZERO;
                }
                return Result.success(duration);
            }
            return Result.failure(Error.NO_ARRIVAL_FOR_LOCATION);
        }
        catch (ExecutionException e) {
            return Result.failure(Error.TECHNICAL_ERROR);
        }
    }

    static enum Error {
        NO_ARRIVAL_FOR_LOCATION,
        TECHNICAL_ERROR;

    }
}

