/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing;

import java.time.Duration;
import org.opentripplanner.framework.model.TimeAndCost;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.DefaultAccessEgress;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RoutingAccessEgress;

public final class RideHailingAccessAdapter
extends DefaultAccessEgress {
    private final Duration arrival;

    public RideHailingAccessAdapter(RoutingAccessEgress access, Duration arrival) {
        super(access.stop(), access.getLastState());
        this.arrival = arrival;
    }

    public RideHailingAccessAdapter(RideHailingAccessAdapter other, TimeAndCost penalty) {
        super(other, penalty);
        this.arrival = other.arrival;
    }

    @Override
    public int earliestDepartureTime(int requestedDepartureTime) {
        return super.earliestDepartureTime(requestedDepartureTime) + (int)this.arrival.toSeconds();
    }

    @Override
    public int latestArrivalTime(int requestedArrivalTime) {
        return super.latestArrivalTime(requestedArrivalTime) + (int)this.arrival.toSeconds();
    }

    public int numberOfRides() {
        return 1;
    }

    @Override
    public boolean hasOpeningHours() {
        return true;
    }

    public String openingHoursToString() {
        return "Arrival in " + this.arrival.toString();
    }

    @Override
    public RoutingAccessEgress withPenalty(TimeAndCost penalty) {
        return new RideHailingAccessAdapter(this, penalty);
    }

    @Override
    public String toString() {
        return this.asString(true, false, null);
    }
}

