/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.ridehailing.model.RideEstimate;
import org.opentripplanner.ext.ridehailing.model.RideHailingLeg;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.ItineraryBuilder;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.StreetLeg;
import org.opentripplanner.routing.algorithm.filterchain.framework.spi.ItineraryListFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecorateWithRideHailing
implements ItineraryListFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DecorateWithRideHailing.class);
    public static final String NO_RIDE_HAILING_AVAILABLE = "no-ride-hailing-available";
    private final List<RideHailingService> rideHailingServices;
    private final boolean wheelchairAccessible;

    public DecorateWithRideHailing(List<RideHailingService> rideHailingServices, boolean wheelchairAccessible) {
        this.rideHailingServices = rideHailingServices;
        this.wheelchairAccessible = wheelchairAccessible;
    }

    @Override
    public List<Itinerary> filter(List<Itinerary> itineraries) {
        return this.rideHailingServices.parallelStream().flatMap(service -> itineraries.parallelStream().map(i -> this.addRideHailingInformation((Itinerary)i, (RideHailingService)service))).toList();
    }

    private static void flagForDeletion(Itinerary i) {
        i.flagForDeletion(new SystemNotice(NO_RIDE_HAILING_AVAILABLE, "This itinerary is marked as deleted by the no-ride-hailing-available filter."));
    }

    private Itinerary addRideHailingInformation(Itinerary i, RideHailingService service) {
        if (!i.isFlaggedForDeletion()) {
            ItineraryBuilder builder = i.copyOf();
            List<Leg> legs = builder.legs().parallelStream().map(leg -> this.decorateLegWithRideEstimate(i, (Leg)leg, service)).toList();
            return builder.withLegs(legs).build();
        }
        return i;
    }

    private Leg decorateLegWithRideEstimate(Itinerary i, Leg leg, RideHailingService service) {
        try {
            StreetLeg sl;
            if (leg instanceof StreetLeg && (sl = (StreetLeg)leg).getMode().isInCar()) {
                List<RideEstimate> estimates = service.rideEstimates(leg.from().coordinate, leg.to().coordinate, this.wheelchairAccessible);
                if (estimates.isEmpty()) {
                    DecorateWithRideHailing.flagForDeletion(i);
                    return leg;
                }
                return new RideHailingLeg(sl, service.provider(), estimates.get(0));
            }
            return leg;
        }
        catch (ExecutionException e) {
            LOG.error("Could not get ride hailing estimate for {}", (Object)service.provider(), (Object)e);
            DecorateWithRideHailing.flagForDeletion(i);
            return leg;
        }
    }
}

