/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.ridehailing.model.ArrivalTime;
import org.opentripplanner.ext.ridehailing.model.RideEstimate;
import org.opentripplanner.ext.ridehailing.model.RideEstimateRequest;
import org.opentripplanner.framework.geometry.WgsCoordinate;

public abstract class CachingRideHailingService
implements RideHailingService {
    private static final Duration CACHE_DURATION = Duration.ofMinutes(2L);
    private final Cache<WgsCoordinate, List<ArrivalTime>> arrivalTimeCache = CacheBuilder.newBuilder().expireAfterWrite(CACHE_DURATION).build();
    private final Cache<RideEstimateRequest, List<RideEstimate>> rideEstimateCache = CacheBuilder.newBuilder().expireAfterWrite(CACHE_DURATION).build();

    @Override
    public List<ArrivalTime> arrivalTimes(WgsCoordinate coordinate, boolean wheelchairAccessible) throws ExecutionException {
        return (List)this.arrivalTimeCache.get((Object)coordinate.roundToApproximate10m(), () -> this.queryArrivalTimes(coordinate, wheelchairAccessible));
    }

    protected abstract List<ArrivalTime> queryArrivalTimes(WgsCoordinate var1, boolean var2) throws IOException;

    @Override
    public List<RideEstimate> rideEstimates(WgsCoordinate start, WgsCoordinate end, boolean wheelchairAccessible) throws ExecutionException {
        RideEstimateRequest request = new RideEstimateRequest(start.roundToApproximate10m(), end.roundToApproximate10m(), wheelchairAccessible);
        return (List)this.rideEstimateCache.get((Object)request, () -> this.queryRideEstimates(request));
    }

    protected abstract List<RideEstimate> queryRideEstimates(RideEstimateRequest var1) throws IOException;
}

