/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.time.Duration;
import org.opentripplanner.ext.reportapi.model.CachedValue;
import org.opentripplanner.ext.reportapi.model.GraphReportBuilder;
import org.opentripplanner.ext.reportapi.model.TransfersReport;
import org.opentripplanner.ext.reportapi.model.TransitGroupPriorityReport;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.service.TransitService;

@Path(value="/report")
@Produces(value={"text/plain"})
public class ReportResource {
    private static final CachedValue<GraphReportBuilder.GraphStats> cachedStats = new CachedValue(Duration.ofMinutes(5L));
    private final TransferService transferService;
    private final TransitService transitService;
    private final RouteRequest defaultRequest;

    public ReportResource(@Context OtpServerRequestContext requestContext) {
        this.transferService = requestContext.transitService().getTransferService();
        this.transitService = requestContext.transitService();
        this.defaultRequest = requestContext.defaultRouteRequest();
    }

    @GET
    @Path(value="/transfers.csv")
    @Produces(value={"application/octet-stream"})
    public String getTransfersAsCsv() {
        return TransfersReport.export(this.transferService.listAll(), this.transitService);
    }

    @GET
    @Path(value="/transit/group/priorities")
    @Produces(value={"text/plain"})
    public String getTransitGroupPriorities() {
        return TransitGroupPriorityReport.build(this.transitService.listTripPatterns(), this.defaultRequest.journey().transit());
    }

    @GET
    @Path(value="/graph.json")
    public Response stats(@Context OtpServerRequestContext serverRequestContext) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)cachedStats.get(() -> GraphReportBuilder.build(serverRequestContext))).type("application/json").build();
    }
}

