/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.model;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.opentripplanner.routing.api.request.request.TransitRequest;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.network.grouppriority.TransitGroupPriorityService;

public class TransitGroupPriorityReport {
    public static String build(Collection<TripPattern> patterns, TransitRequest request) {
        TransitGroupPriorityService service = new TransitGroupPriorityService(request.priorityGroupsByAgency(), request.priorityGroupsGlobal());
        TreeMap<Integer, DebugEntity> map = new TreeMap<Integer, DebugEntity>();
        for (TripPattern it : patterns) {
            int groupId = service.lookupTransitGroupPriorityId(it);
            DebugEntity de = map.computeIfAbsent(groupId, DebugEntity::new);
            de.add(it.getRoute().getAgency().getId().toString(), it.getMode().name(), it.getNetexSubmode().name());
        }
        return "TRANSIT GROUPS PRIORITY" + map.values().stream().map(DebugEntity::toString).sorted().collect(Collectors.joining(""));
    }

    private static class DebugEntity {
        private final int groupId;
        private final TreeMap<String, AgencyEntry> agencies = new TreeMap();

        public DebugEntity(int groupId) {
            this.groupId = groupId;
        }

        void add(String agency, String mode, String submode) {
            this.agencies.computeIfAbsent(agency, AgencyEntry::new).add(mode, submode);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("\n  %#010x".formatted(this.groupId));
            for (AgencyEntry it : this.agencies.values()) {
                buf.append("\n    ").append(it.toString());
            }
            return buf.toString();
        }
    }

    private record AgencyEntry(String agency, TreeMap<String, TreeSet<String>> modes) {
        private AgencyEntry(String agency) {
            this(agency, new TreeMap<String, TreeSet<String>>());
        }

        void add(String mode, String submode) {
            this.modes.computeIfAbsent(mode, m -> new TreeSet()).add(submode);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (Map.Entry<String, TreeSet<String>> it : this.modes.entrySet()) {
                buf.append(", ");
                buf.append(it.getKey());
                if (it.getValue().isEmpty()) continue;
                buf.append(" (").append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)it.getValue())).append(")");
            }
            return this.agency + " ~ " + buf.substring(2);
        }
    }
}

