/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.realtimeresolver;

import java.util.List;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLeg;
import org.opentripplanner.model.plan.leg.ScheduledTransitLegBuilder;
import org.opentripplanner.model.plan.legreference.LegReference;
import org.opentripplanner.transit.service.TransitService;

public class RealtimeResolver {
    private final TransitService transitService;

    public RealtimeResolver(TransitService transitService) {
        this.transitService = transitService;
    }

    public static List<Itinerary> populateLegsWithRealtime(List<Itinerary> itineraries, TransitService transitService) {
        return new RealtimeResolver(transitService).addRealtimeInfo(itineraries);
    }

    private List<Itinerary> addRealtimeInfo(List<Itinerary> itineraries) {
        return itineraries.stream().map(this::decorateItinerary).toList();
    }

    private Itinerary decorateItinerary(Itinerary it) {
        if (it.isFlaggedForDeletion()) {
            return it;
        }
        return it.copyOf().transformLegs(this::mapLeg).build();
    }

    private Leg mapLeg(Leg leg) {
        LegReference ref = leg.legReference();
        if (ref == null) {
            return leg;
        }
        if (!leg.isScheduledTransitLeg()) {
            return leg;
        }
        Leg realTimeLeg = ref.getLeg(this.transitService);
        if (realTimeLeg == null) {
            return leg;
        }
        return RealtimeResolver.combineReferenceWithOriginal(realTimeLeg.asScheduledTransitLeg(), leg.asScheduledTransitLeg());
    }

    private static Leg combineReferenceWithOriginal(ScheduledTransitLeg reference, ScheduledTransitLeg original) {
        return ((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)((ScheduledTransitLegBuilder)new ScheduledTransitLegBuilder(reference).withTransferFromPreviousLeg(original.transferFromPrevLeg())).withTransferToNextLeg(original.transferToNextLeg())).withGeneralizedCost(original.generalizedCost())).withAccessibilityScore(original.accessibilityScore())).build();
    }
}

