/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.parkAndRideApi;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.graphfinder.GraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.service.vehicleparking.VehicleParkingService;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/routers/{ignoreRouterId}/park_and_ride")
public class ParkAndRideResource {
    private final VehicleParkingService vehicleParkingService;
    private final GraphFinder graphFinder;

    public ParkAndRideResource(@Context OtpServerRequestContext serverContext, @Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.vehicleParkingService = serverContext.vehicleParkingService();
        this.graphFinder = new DirectGraphFinder(serverContext.transitService()::findRegularStopsByBoundingBox);
    }

    public static Envelope getEnvelope(String lowerLeft, String upperRight) {
        String[] lowerLeftParts = lowerLeft.split(",");
        String[] upperRightParts = upperRight.split(",");
        return new Envelope(Double.parseDouble(lowerLeftParts[1]), Double.parseDouble(upperRightParts[1]), Double.parseDouble(lowerLeftParts[0]), Double.parseDouble(upperRightParts[0]));
    }

    @GET
    @Produces(value={"application/json"})
    public Response getParkAndRide(@QueryParam(value="lowerLeft") String lowerLeft, @QueryParam(value="upperRight") String upperRight, @QueryParam(value="maxTransitDistance") Double maxTransitDistance) {
        Envelope envelope = lowerLeft != null ? ParkAndRideResource.getEnvelope(lowerLeft, upperRight) : new Envelope(-180.0, 180.0, -90.0, 90.0);
        List<ParkAndRideInfo> prs = this.vehicleParkingService.listCarParks().stream().filter(lot -> envelope.contains(lot.getCoordinate().asJtsCoordinate())).filter(lot -> this.hasTransitStopsNearby(maxTransitDistance, (VehicleParking)lot)).map(ParkAndRideInfo::ofVehicleParking).toList();
        return Response.status((Response.Status)Response.Status.OK).entity(prs).build();
    }

    private boolean hasTransitStopsNearby(Double maxTransitDistance, VehicleParking lot) {
        if (maxTransitDistance == null) {
            return true;
        }
        List<NearbyStop> stops = this.graphFinder.findClosestStops(lot.getCoordinate().asJtsCoordinate(), maxTransitDistance);
        return !stops.isEmpty();
    }

    public record ParkAndRideInfo(String name, double x, double y) {
        public static ParkAndRideInfo ofVehicleParking(VehicleParking parking) {
            String name = Optional.ofNullable(parking.getName()).map(I18NString::toString).orElse(parking.getId().getId());
            return new ParkAndRideInfo(name, parking.getCoordinate().longitude(), parking.getCoordinate().latitude());
        }
    }
}

