/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.support;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.opentripplanner.framework.application.OtpFileNames;

public class SearchForOtpConfig {
    private static final int DEPTH_LIMIT = 10;
    private static final Pattern EXCLUDE_DIR = Pattern.compile("(otp1|archive|\\..*|te?mp|target|docs?|src|source|resource)");

    public static List<File> search(File rootDir) {
        return SearchForOtpConfig.recursiveSearch(rootDir, 10).toList();
    }

    private static Stream<File> recursiveSearch(File dir, int depthLimit) {
        if (!dir.isDirectory() || depthLimit == 0) {
            return Stream.empty();
        }
        if (EXCLUDE_DIR.matcher(dir.getName()).matches()) {
            return Stream.empty();
        }
        if (SearchForOtpConfig.isOtpConfigDataDir(dir)) {
            return Stream.of(dir);
        }
        int newDepthLimit = depthLimit - 1;
        File[] files = dir.listFiles();
        if (files == null) {
            return Stream.empty();
        }
        return Arrays.stream(files).flatMap(f -> SearchForOtpConfig.recursiveSearch(f, newDepthLimit));
    }

    private static boolean isOtpConfigDataDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File f : files) {
            if (!OtpFileNames.isConfigFile(f.getName())) continue;
            return true;
        }
        return false;
    }
}

