/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.startup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.opentripplanner.ext.interactivelauncher.support.SearchForOtpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupModel {
    private static final Logger LOG = LoggerFactory.getLogger(StartupModel.class);
    @JsonIgnore
    private transient Consumer<String> commandLineChange;
    private String rootDirectory = null;
    private String dataSource = null;
    private boolean buildStreet = false;
    private boolean buildTransit = true;
    private boolean saveGraph = false;
    private boolean serveGraph = true;
    private boolean visualizer = false;

    public void subscribeCmdLineUpdates(Consumer<String> commandLineChange) {
        this.commandLineChange = commandLineChange;
    }

    public String getRootDirectory() {
        return this.rootDirectory == null ? System.getProperty("user.dir") : this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        if (rootDirectory != null) {
            this.rootDirectory = rootDirectory;
        }
        this.notifyChangeListener();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
        this.notifyChangeListener();
    }

    @JsonIgnore
    public List<String> getDataSourceOptions() {
        ArrayList<String> dataSourceOptions = new ArrayList<String>();
        File rootDir = new File(this.getRootDirectory());
        List<File> dirs = SearchForOtpConfig.search(rootDir);
        int length = rootDir.getAbsolutePath().length() + 1;
        for (File dir : dirs) {
            String path = dir.getAbsolutePath();
            if (path.length() <= length) {
                LOG.warn("The root directory contains a config file, choose the parent directory or delete the config file.");
                continue;
            }
            dataSourceOptions.add(path.substring(length));
        }
        return dataSourceOptions;
    }

    public boolean isBuildStreet() {
        return this.buildStreet;
    }

    public void setBuildStreet(boolean buildStreet) {
        this.buildStreet = buildStreet;
        this.notifyChangeListener();
    }

    public boolean isBuildTransit() {
        return this.buildTransit;
    }

    public void setBuildTransit(boolean buildTransit) {
        this.buildTransit = buildTransit;
        this.notifyChangeListener();
    }

    public boolean isSaveGraph() {
        return this.saveGraph;
    }

    public void setSaveGraph(boolean saveGraph) {
        this.saveGraph = saveGraph;
        this.notifyChangeListener();
    }

    public boolean isServeGraph() {
        return this.serveGraph;
    }

    public void setServeGraph(boolean serveGraph) {
        this.serveGraph = serveGraph;
        this.notifyChangeListener();
    }

    public boolean isVisualizer() {
        return this.visualizer;
    }

    public void setVisualizer(boolean visualizer) {
        this.visualizer = visualizer;
        this.notifyChangeListener();
    }

    public String toString() {
        return String.join((CharSequence)"", this.asOtpArgs());
    }

    public String toCliString() {
        return String.join((CharSequence)" ", this.asOtpArgs());
    }

    private void notifyChangeListener() {
        if (this.commandLineChange != null) {
            this.commandLineChange.accept(this.toCliString());
        }
    }

    @JsonIgnore
    String getDataSourceDirectory() {
        if (this.dataSource == null) {
            return "DATA_SOURCE_NOT_SET";
        }
        return this.getRootDirectory() + File.separatorChar + this.dataSource;
    }

    public String[] asOtpArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.buildAll()) {
            args.add("--build");
        } else if (this.buildStreet) {
            args.add("--buildStreet");
        } else if (this.buildTransit) {
            args.add("--loadStreet");
        } else {
            args.add("--load");
        }
        if (this.saveGraph && (this.buildTransit || this.buildStreet)) {
            args.add("--save");
        }
        if (this.serveGraph && !this.buildStreetOnly()) {
            args.add("--serve");
        }
        if (this.serveGraph && !this.buildStreetOnly() && this.visualizer) {
            args.add("--visualize");
        }
        args.add(this.getDataSourceDirectory());
        return args.toArray(new String[0]);
    }

    private boolean buildAll() {
        return this.buildStreet && this.buildTransit;
    }

    private boolean buildStreetOnly() {
        return this.buildStreet && !this.buildTransit;
    }
}

