/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.startup;

import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.opentripplanner.ext.interactivelauncher.startup.StartupModel;
import org.opentripplanner.ext.interactivelauncher.support.ViewUtils;

class OptionsView {
    private final Box panel = Box.createHorizontalBox();
    private final JCheckBox buildStreetGraphChk;
    private final JCheckBox buildTransitGraphChk;
    private final JCheckBox saveGraphChk;
    private final JCheckBox startOptServerChk;
    private final JCheckBox startOptVisualizerChk;
    private final StartupModel model;

    OptionsView(StartupModel model) {
        this.model = model;
        this.buildStreetGraphChk = new JCheckBox("Street graph", model.isBuildStreet());
        this.buildTransitGraphChk = new JCheckBox("Transit graph", model.isBuildTransit());
        this.saveGraphChk = new JCheckBox("Save graph", model.isSaveGraph());
        this.startOptServerChk = new JCheckBox("Serve graph", model.isServeGraph());
        this.startOptVisualizerChk = new JCheckBox("Visualizer", model.isVisualizer());
        this.panel.add(Box.createGlue());
        ViewUtils.addComp(this.createBuildBox(), this.panel);
        this.panel.add(Box.createGlue());
        ViewUtils.addComp(this.createActionBox(), this.panel);
        this.panel.add(Box.createGlue());
        this.buildStreetGraphChk.addActionListener(e -> this.onBuildGraphChkChanged());
        this.buildTransitGraphChk.addActionListener(e -> this.onBuildGraphChkChanged());
        this.startOptServerChk.addActionListener(e -> this.onStartOptServerChkChanged());
        this.bindCheckBoxesToModel();
    }

    private JComponent createBuildBox() {
        Box buildBox = Box.createVerticalBox();
        ViewUtils.addLabel("Build graph", buildBox);
        ViewUtils.addVerticalSectionSpace(buildBox);
        ViewUtils.addComp(this.buildStreetGraphChk, buildBox);
        ViewUtils.addComp(this.buildTransitGraphChk, buildBox);
        buildBox.add(Box.createVerticalGlue());
        return buildBox;
    }

    private JComponent createActionBox() {
        Box actionBox = Box.createVerticalBox();
        ViewUtils.addLabel("Actions", actionBox);
        ViewUtils.addVerticalSectionSpace(actionBox);
        ViewUtils.addComp(this.saveGraphChk, actionBox);
        ViewUtils.addComp(this.startOptServerChk, actionBox);
        ViewUtils.addComp(this.startOptVisualizerChk, actionBox);
        return actionBox;
    }

    Box panel() {
        return this.panel;
    }

    void initState() {
        this.onBuildGraphChkChanged();
    }

    void bind(JCheckBox box, Consumer<Boolean> modelUpdate) {
        box.addActionListener(l -> modelUpdate.accept(box.isSelected() && box.isEnabled()));
    }

    private void bindCheckBoxesToModel() {
        this.bind(this.buildStreetGraphChk, this.model::setBuildStreet);
        this.bind(this.buildTransitGraphChk, this.model::setBuildTransit);
        this.bind(this.saveGraphChk, this.model::setSaveGraph);
        this.bind(this.startOptServerChk, this.model::setServeGraph);
        this.bind(this.startOptVisualizerChk, this.model::setVisualizer);
    }

    private boolean buildStreet() {
        return this.buildStreetGraphChk.isSelected();
    }

    private boolean buildTransit() {
        return this.buildTransitGraphChk.isSelected();
    }

    private void onBuildGraphChkChanged() {
        this.saveGraphChk.setEnabled(this.buildStreet() || this.buildTransit());
        this.startOptServerChk.setEnabled(this.buildTransit() || !this.buildStreet());
        this.startOptVisualizerChk.setEnabled(this.buildTransit() || !this.buildStreet());
    }

    private void onStartOptServerChkChanged() {
        this.startOptVisualizerChk.setEnabled(this.startOptServerChk.isEnabled() && this.startOptServerChk.isSelected());
    }
}

