/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.startup;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opentripplanner.ext.interactivelauncher.startup.DataSourceRootView;
import org.opentripplanner.ext.interactivelauncher.startup.DataSourcesView;
import org.opentripplanner.ext.interactivelauncher.startup.OptionsView;
import org.opentripplanner.ext.interactivelauncher.startup.StartOtpButtonView;
import org.opentripplanner.ext.interactivelauncher.startup.StartupModel;
import org.opentripplanner.ext.interactivelauncher.startup.StatusBar;
import org.opentripplanner.ext.interactivelauncher.support.ViewUtils;

public class MainView {
    private static final int M_IN = 10;
    private static final int M_OUT = 20;
    private static final Insets DEFAULT_INSETS = new Insets(20, 20, 10, 20);
    private static final Insets SMALL_INSETS = new Insets(20, 20, 10, 20);
    private static int Y = 0;
    private static final GridBagConstraints DATA_SOURCE_ROOT_PANEL_CONSTRAINTS = MainView.gbc(0.0f);
    private static final GridBagConstraints DATA_SOURCE_LIST_PANEL_CONSTRAINTS = MainView.gbc(1.0f);
    private static final GridBagConstraints OPTIONS_PANEL_CONSTRAINTS = MainView.gbc(1.0f);
    private static final GridBagConstraints START_BUTTON_PANEL_CONSTRAINTS = MainView.gbc(0.0f);
    private static final GridBagConstraints STATUS_BAR_CONSTRAINTS = MainView.gbc(0.0f, SMALL_INSETS, 40);
    private final JFrame mainFrame = new JFrame("Setup and Run OTP Main");
    private final DataSourcesView dataSourcesView;
    private final OptionsView optionsView;
    private final StartOtpButtonView startOtpButtonView;
    private final Runnable otpStarter;
    private final StartupModel model;

    public MainView(Runnable otpStarter, StartupModel model) throws HeadlessException {
        JPanel innerPanel = new JPanel();
        StatusBar statusBarTxt = new StatusBar();
        this.otpStarter = otpStarter;
        this.model = model;
        this.mainFrame.setContentPane(new JScrollPane(innerPanel));
        GridBagLayout layout = new GridBagLayout();
        innerPanel.setLayout(layout);
        innerPanel.setBackground(ViewUtils.BACKGROUND);
        DataSourceRootView sourceDirectoryView = new DataSourceRootView(model.getRootDirectory(), this::onRootDirChanged);
        this.dataSourcesView = new DataSourcesView(model);
        this.optionsView = new OptionsView(model);
        this.startOtpButtonView = new StartOtpButtonView();
        innerPanel.add((Component)sourceDirectoryView.panel(), DATA_SOURCE_ROOT_PANEL_CONSTRAINTS);
        innerPanel.add((Component)this.dataSourcesView.panel(), DATA_SOURCE_LIST_PANEL_CONSTRAINTS);
        innerPanel.add((Component)this.optionsView.panel(), OPTIONS_PANEL_CONSTRAINTS);
        innerPanel.add((Component)this.startOtpButtonView.panel(), START_BUTTON_PANEL_CONSTRAINTS);
        innerPanel.add((Component)statusBarTxt, STATUS_BAR_CONSTRAINTS);
        this.startOtpButtonView.addActionListener(e -> this.startOtp());
        ViewUtils.debugLayout(sourceDirectoryView.panel(), this.dataSourcesView.panel(), this.optionsView.panel(), this.startOtpButtonView.panel(), statusBarTxt);
        model.subscribeCmdLineUpdates(statusBarTxt::setText);
        statusBarTxt.setText(model.toCliString());
    }

    public void onRootDirChanged(String newRootDir) {
        this.model.setRootDirectory(newRootDir);
        this.dataSourcesView.onRootDirChange();
        this.mainFrame.pack();
        this.mainFrame.repaint();
    }

    public void start() {
        this.mainFrame.setDefaultCloseOperation(3);
        this.optionsView.initState();
        this.mainFrame.pack();
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setVisible(true);
        this.startOtpButtonView.grabFocus();
    }

    private void startOtp() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        this.otpStarter.run();
    }

    private static GridBagConstraints gbc(float weighty) {
        return MainView.gbc(weighty, DEFAULT_INSETS, 0);
    }

    private static GridBagConstraints gbc(float weighty, Insets insets, int ipadx) {
        return new GridBagConstraints(0, Y++, 1, 1, 1.0, weighty, 10, 2, insets, ipadx, 0);
    }
}

