/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.startup;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.opentripplanner.ext.interactivelauncher.startup.StartupModel;
import org.opentripplanner.ext.interactivelauncher.support.ViewUtils;

class DataSourcesView {
    private final Box mainPanel = Box.createVerticalBox();
    private final Box listPanel = Box.createHorizontalBox();
    private final StartupModel model;

    public DataSourcesView(StartupModel model) {
        this.model = model;
        this.setupDataSources();
        ViewUtils.addLabel("Select data source", this.mainPanel);
        ViewUtils.addVerticalSectionSpace(this.mainPanel);
        this.listPanel.setAlignmentX(0.0f);
        ViewUtils.addComp(this.listPanel, this.mainPanel);
    }

    public JComponent panel() {
        return this.mainPanel;
    }

    public void onRootDirChange() {
        this.model.setDataSource(null);
        this.listPanel.removeAll();
        this.setupDataSources();
        this.listPanel.repaint();
    }

    public void onDataSourceChange(ActionEvent e) {
        this.model.setDataSource(e.getActionCommand());
    }

    private void setupDataSources() {
        List<String> values = this.model.getDataSourceOptions();
        if (values.isEmpty()) {
            this.model.setDataSource(null);
            JLabel label = new JLabel("<No otp configuration files found>");
            label.setBackground(ViewUtils.BG_STATUS_BAR);
            label.setForeground(ViewUtils.FG_STATUS_BAR);
            ViewUtils.addComp(label, this.listPanel);
            return;
        }
        String selectedValue = this.model.getDataSource();
        if (selectedValue == null) {
            selectedValue = values.get(0);
            this.model.setDataSource(selectedValue);
        }
        ButtonGroup selectDataSourceRadioGroup = new ButtonGroup();
        List<String> valuesSorted = values.stream().sorted().toList();
        int size = valuesSorted.size();
        if (size <= 10) {
            this.addListPanel(valuesSorted, selectedValue, selectDataSourceRadioGroup);
        } else if (size <= 20) {
            int half = size / 2;
            this.addListPanel(valuesSorted.subList(0, half), selectedValue, selectDataSourceRadioGroup);
            ViewUtils.addHorizontalGlue(this.listPanel);
            this.addListPanel(valuesSorted.subList(half, size), selectedValue, selectDataSourceRadioGroup);
        } else {
            int third = size / 3;
            this.addListPanel(valuesSorted.subList(0, third), selectedValue, selectDataSourceRadioGroup);
            ViewUtils.addHorizontalGlue(this.listPanel);
            this.addListPanel(valuesSorted.subList(third, third * 2), selectedValue, selectDataSourceRadioGroup);
            ViewUtils.addHorizontalGlue(this.listPanel);
            this.addListPanel(valuesSorted.subList(third * 2, size), selectedValue, selectDataSourceRadioGroup);
        }
    }

    private void addListPanel(List<String> values, String selectedValue, ButtonGroup selectDataSourceRadioGroup) {
        Box column = Box.createVerticalBox();
        for (String name : values) {
            boolean selected = selectedValue.equals(name);
            JRadioButton radioBtn = DataSourcesView.newRadioBtn(selectDataSourceRadioGroup, name, selected);
            radioBtn.addActionListener(this::onDataSourceChange);
            ViewUtils.addComp(radioBtn, column);
        }
        ViewUtils.addComp(column, this.listPanel);
    }

    private static JRadioButton newRadioBtn(ButtonGroup group, String name, boolean selected) {
        JRadioButton radioButton = new JRadioButton(name, selected);
        group.add(radioButton);
        return radioButton;
    }
}

