/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.startup;

import java.awt.Dimension;
import java.io.File;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.opentripplanner.ext.interactivelauncher.support.ViewUtils;

class DataSourceRootView {
    private final Box panel;
    private final JTextField fileTxt = new JTextField();
    private final JButton searchBtn = new JButton("Open");
    private final Consumer<String> rootDirChangedListener;

    DataSourceRootView(String dir, Consumer<String> rootDirChangedListener) {
        this.fileTxt.setText(dir);
        this.rootDirChangedListener = rootDirChangedListener;
        this.panel = Box.createVerticalBox();
        JLabel lbl = new JLabel("Data source root");
        lbl.setAlignmentX(0.0f);
        this.panel.add(lbl);
        this.fileTxt.setEditable(false);
        this.fileTxt.setBackground(ViewUtils.BG_STATUS_BAR);
        this.fileTxt.setForeground(ViewUtils.FG_STATUS_BAR);
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(this.fileTxt);
        box.add(this.searchBtn);
        this.searchBtn.addActionListener(l -> this.onSelectSource());
        this.panel.add(box);
    }

    public JComponent panel() {
        return this.panel;
    }

    Dimension minWidth(Dimension d, int minWidth) {
        return new Dimension(Math.max(minWidth, d.width), d.height);
    }

    private void onSelectSource() {
        JFileChooser chooser = new JFileChooser(new File(this.fileTxt.getText()));
        chooser.setBackground(ViewUtils.BACKGROUND);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Choose directory to search");
        chooser.setCurrentDirectory(new File(this.fileTxt.getText()));
        chooser.setApproveButtonToolTipText("Select the directory to search for OTP data sources");
        int status = chooser.showDialog(this.panel, "Search");
        if (status == 0) {
            File dir = chooser.getSelectedFile();
            if (!dir.exists()) {
                dir = dir.getParentFile();
            }
            this.fileTxt.setText(dir.getAbsolutePath());
            this.rootDirChangedListener.accept(dir.getAbsolutePath());
        }
    }
}

