/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.debug.raptor;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.opentripplanner.ext.interactivelauncher.debug.raptor.RaptorDebugModel;
import org.opentripplanner.ext.interactivelauncher.support.ViewUtils;
import org.opentripplanner.routing.api.request.DebugEventType;

public class RaptorDebugView {
    private final RaptorDebugModel model;
    private final Box panel = Box.createVerticalBox();
    private final JCheckBox logStopArrivalsChk = new JCheckBox("Stop arrivals");
    private final JCheckBox logPatternRidesChk = new JCheckBox("Pattern rides");
    private final JCheckBox logDestinationArrivalsChk = new JCheckBox("Destination arrivals");
    private final JTextField stopsTxt = new JTextField(40);
    private final JTextField pathTxt = new JTextField(40);

    public RaptorDebugView(RaptorDebugModel model) {
        this.model = model;
        ViewUtils.addLabel("Log Raptor events for", this.panel);
        ViewUtils.addComp(this.logStopArrivalsChk, this.panel);
        ViewUtils.addComp(this.logPatternRidesChk, this.panel);
        ViewUtils.addComp(this.logDestinationArrivalsChk, this.panel);
        ViewUtils.addVerticalSectionSpace(this.panel);
        ViewUtils.addLabel("A list of stops to debug", this.panel);
        ViewUtils.addComp(this.stopsTxt, this.panel);
        ViewUtils.addVerticalSectionSpace(this.panel);
        ViewUtils.addLabel("A a path (as a list of stops) to debug", this.panel);
        ViewUtils.addComp(this.pathTxt, this.panel);
        ViewUtils.addVerticalSectionSpace(this.panel);
        this.initValues();
        this.setupActionListeners();
    }

    private void initValues() {
        this.logStopArrivalsChk.setSelected(this.model.isEventTypeSet(DebugEventType.STOP_ARRIVALS));
        this.logPatternRidesChk.setSelected(this.model.isEventTypeSet(DebugEventType.PATTERN_RIDES));
        this.logDestinationArrivalsChk.setSelected(this.model.isEventTypeSet(DebugEventType.DESTINATION_ARRIVALS));
        this.stopsTxt.setText(this.model.getStops());
        this.pathTxt.setText(this.model.getPath());
    }

    private void setupActionListeners() {
        this.setupActionListenerChkBox(this.logStopArrivalsChk, DebugEventType.STOP_ARRIVALS);
        this.setupActionListenerChkBox(this.logPatternRidesChk, DebugEventType.PATTERN_RIDES);
        this.setupActionListenerChkBox(this.logDestinationArrivalsChk, DebugEventType.DESTINATION_ARRIVALS);
        RaptorDebugView.setupActionListenerTextField(this.stopsTxt, this.model::setStops);
        RaptorDebugView.setupActionListenerTextField(this.pathTxt, this.model::setPath);
    }

    public Component panel() {
        return this.panel;
    }

    private void setupActionListenerChkBox(JCheckBox box, DebugEventType type) {
        box.addActionListener(l -> this.model.enableEventTypes(type, box.isSelected()));
    }

    private static void setupActionListenerTextField(final JTextField txtField, final Consumer<String> model) {
        txtField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                model.accept(txtField.getText());
            }
        });
    }
}

