/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.debug.raptor;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.ext.interactivelauncher.api.LauncherRequestDecorator;
import org.opentripplanner.routing.api.request.DebugEventType;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.utils.lang.StringUtils;

public class RaptorDebugModel
implements LauncherRequestDecorator {
    private final Set<DebugEventType> eventTypes = EnumSet.noneOf(DebugEventType.class);
    private String stops = null;
    private String path = null;
    private Runnable saveCallback;

    public void init(Runnable saveCallback) {
        this.saveCallback = saveCallback;
    }

    public Set<DebugEventType> getEventTypes() {
        return Collections.unmodifiableSet(this.eventTypes);
    }

    public void setEventTypes(Collection<DebugEventType> eventTypes) {
        this.eventTypes.clear();
        this.eventTypes.addAll(eventTypes);
    }

    public void enableEventTypes(DebugEventType eventType, boolean enable) {
        if (enable) {
            if (!this.isEventTypeSet(eventType)) {
                this.eventTypes.add(eventType);
                this.save();
            }
        } else if (this.isEventTypeSet(eventType)) {
            this.eventTypes.remove((Object)eventType);
            this.save();
        }
    }

    @Nullable
    public String getStops() {
        return this.stops;
    }

    public void setStops(@Nullable String stops) {
        String string = stops = StringUtils.hasValue((String)stops) ? stops : null;
        if (!Objects.equals(this.stops, stops)) {
            this.stops = stops;
            this.save();
        }
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String path) {
        String string = path = StringUtils.hasValue((String)path) ? path : null;
        if (!Objects.equals(this.path, path)) {
            this.path = path;
            this.save();
        }
    }

    public boolean isEventTypeSet(DebugEventType eventType) {
        return this.eventTypes.contains((Object)eventType);
    }

    @Override
    public RouteRequest intercept(RouteRequest defaultRequest) {
        return defaultRequest.copyOf().withJourney(jb -> jb.withTransit(tb -> tb.withRaptorDebugging(rd -> rd.withEventTypes(this.eventTypes).withStops(this.stops).withPath(this.path)))).buildDefault();
    }

    private void save() {
        if (this.saveCallback != null) {
            this.saveCallback.run();
        }
    }
}

