/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.debug.logging;

import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.opentripplanner.ext.interactivelauncher.debug.logging.DebugLoggers;
import org.opentripplanner.ext.interactivelauncher.debug.logging.LogModel;

public class LogView {
    private final Box panel = Box.createVerticalBox();
    private final LogModel model;

    public LogView(LogModel model) {
        this.model = model;
        DebugLoggers.list().forEach(this::add);
    }

    public JComponent panel() {
        return this.panel;
    }

    private void add(DebugLoggers.Entry entry) {
        JCheckBox box = new JCheckBox(entry.label());
        box.setToolTipText("Logger: " + entry.logger());
        box.setSelected(this.model.isLoggerEnabled(entry.logger()));
        box.addActionListener(e -> this.selectLogger(entry.logger(), box.isSelected()));
        this.panel.add(box);
    }

    private void selectLogger(String logger, boolean selected) {
        this.model.turnLoggerOnOff(logger, selected);
    }
}

