/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.debug.logging;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.ext.interactivelauncher.debug.logging.DebugLoggers;
import org.opentripplanner.ext.interactivelauncher.debug.logging.DebugLoggingSupport;

public class LogModel
implements Serializable {
    private final Set<String> activeLoggers = new HashSet<String>();
    @JsonIgnore
    private Runnable saveCallback;

    public static LogModel createFromConfig() {
        LogModel model = new LogModel();
        model.initFromConfig();
        return model;
    }

    public void init(Runnable saveCallback) {
        this.saveCallback = saveCallback;
    }

    public Collection<String> getActiveLoggers() {
        return List.copyOf(this.activeLoggers);
    }

    public void setActiveLoggers(Collection<String> loggers) {
        this.activeLoggers.clear();
        this.activeLoggers.addAll(loggers);
        for (String logger : this.activeLoggers) {
            DebugLoggingSupport.configureDebugLogging(logger, true);
        }
    }

    boolean isLoggerEnabled(String name) {
        return this.activeLoggers.contains(name);
    }

    void turnLoggerOnOff(String name, boolean enable) {
        if (enable) {
            if (!this.activeLoggers.contains(name)) {
                this.activeLoggers.add(name);
                DebugLoggingSupport.configureDebugLogging(name, enable);
                this.save();
            }
        } else if (this.activeLoggers.contains(name)) {
            this.activeLoggers.remove(name);
            DebugLoggingSupport.configureDebugLogging(name, enable);
            this.save();
        }
    }

    private void initFromConfig() {
        List<String> debugLoggers = DebugLoggers.listLoggers();
        for (String logger : DebugLoggingSupport.listConfiguredDebugLoggers()) {
            if (!debugLoggers.contains(logger)) continue;
            this.activeLoggers.add(logger);
        }
    }

    private void save() {
        if (this.saveCallback != null) {
            this.saveCallback.run();
        }
    }
}

