/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.debug.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

class DebugLoggingSupport {
    private static final String OTP = Pattern.quote("org.opentripplanner.") + ".*";
    private static final String GRAPHQL = Pattern.quote("fea");
    private static final String NAMED_LOGGERS = Pattern.quote("[A-Z0-9_]*");
    private static final Pattern LOG_MATCHER_PATTERN = Pattern.compile("(" + OTP + "|" + GRAPHQL + "|" + NAMED_LOGGERS + ")");

    DebugLoggingSupport() {
    }

    static List<String> listConfiguredDebugLoggers() {
        ArrayList<String> result = new ArrayList<String>();
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger log : context.getLoggerList()) {
            String name = log.getName();
            if (name.equals("ROOT") || log.getLevel() == null || log.getLevel().toInt() > Level.DEBUG.toInt() || !LOG_MATCHER_PATTERN.matcher(name).matches()) continue;
            result.add(name);
        }
        return result;
    }

    static void configureDebugLogging(String logger, boolean debug) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger log = context.getLogger(logger);
        log.setLevel(debug ? Level.DEBUG : Level.INFO);
    }
}

