/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.debug;

import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.opentripplanner.ext.interactivelauncher.Model;
import org.opentripplanner.ext.interactivelauncher.debug.logging.LogView;
import org.opentripplanner.ext.interactivelauncher.debug.raptor.RaptorDebugView;
import org.opentripplanner.ext.interactivelauncher.support.ViewUtils;

public class OtpDebugController {
    private final JFrame debugFrame = new JFrame("OTP Debug Controller");

    public OtpDebugController(Model model) {
        this.debugFrame.add(OtpDebugController.createTabbedPane(model));
        this.debugFrame.getContentPane().setBackground(ViewUtils.BACKGROUND);
    }

    public void start() {
        this.debugFrame.setDefaultCloseOperation(2);
        this.debugFrame.pack();
        this.debugFrame.setLocationRelativeTo(null);
        this.debugFrame.setVisible(true);
    }

    private static JTabbedPane createTabbedPane(Model model) {
        JTabbedPane tabPanel = new JTabbedPane();
        tabPanel.addTab("Logging", new LogView(model.getLogModel()).panel());
        tabPanel.addTab("Raptor", new RaptorDebugView(model.getRaptorDebugModel()).panel());
        return tabPanel;
    }
}

