/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.opentripplanner.ext.interactivelauncher.debug.logging.LogModel;
import org.opentripplanner.ext.interactivelauncher.debug.raptor.RaptorDebugModel;
import org.opentripplanner.ext.interactivelauncher.startup.StartupModel;

public class Model
implements Serializable {
    private static final File MODEL_FILE = new File("interactive_otp_main.json");
    private StartupModel startupModel;
    private LogModel logModel;
    private RaptorDebugModel raptorDebugModel;

    public static Model load() {
        return MODEL_FILE.exists() ? Model.readFromFile() : Model.createNew();
    }

    public StartupModel getStartupModel() {
        return this.startupModel;
    }

    public LogModel getLogModel() {
        return this.logModel;
    }

    public RaptorDebugModel getRaptorDebugModel() {
        return this.raptorDebugModel;
    }

    private static Model createNew() {
        return new Model().initSubModels();
    }

    private static Model readFromFile() {
        try {
            ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return ((Model)mapper.readValue(MODEL_FILE, Model.class)).initSubModels();
        }
        catch (IOException e) {
            System.err.println("Unable to read the InteractiveOtpMain state cache. If the model changed this is expected, and it will work next time. Cause: " + e.getMessage());
            return Model.createNew();
        }
    }

    void save() {
        try {
            ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.INDENT_OUTPUT, true);
            mapper.writeValue(MODEL_FILE, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Model initSubModels() {
        if (this.startupModel == null) {
            this.startupModel = new StartupModel();
        }
        if (this.logModel == null) {
            this.logModel = LogModel.createFromConfig();
        }
        if (this.raptorDebugModel == null) {
            this.raptorDebugModel = new RaptorDebugModel();
        }
        this.logModel.init(this::save);
        this.raptorDebugModel.init(this::save);
        return this;
    }
}

