/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher;

import org.opentripplanner.ext.interactivelauncher.Model;
import org.opentripplanner.ext.interactivelauncher.configuration.InteractiveLauncherModule;
import org.opentripplanner.ext.interactivelauncher.debug.OtpDebugController;
import org.opentripplanner.ext.interactivelauncher.startup.MainView;
import org.opentripplanner.standalone.OTPMain;

public class InteractiveOtpMain {
    private Model model;

    public static void main(String[] args) {
        new InteractiveOtpMain().run();
    }

    private void run() {
        this.model = Model.load();
        MainView frame = new MainView(new Thread(this::startOtp)::start, this.model.getStartupModel());
        frame.start();
    }

    private void startOtp() {
        this.model.save();
        this.startDebugControllerAndSetupRequestInterceptor();
        System.out.println("Start OTP: " + String.valueOf(this.model) + "\n");
        OTPMain.main(this.model.getStartupModel().asOtpArgs());
    }

    private void startDebugControllerAndSetupRequestInterceptor() {
        new OtpDebugController(this.model).start();
        InteractiveLauncherModule.setRequestInterceptor(this.model.getRaptorDebugModel());
    }
}

