/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.geocoder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.ext.geocoder.LuceneStopCluster;
import org.opentripplanner.ext.geocoder.StopCluster;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.ext.stopconsolidation.model.StopReplacement;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.collection.ListUtils;

class StopClusterMapper {
    private final TransitService transitService;
    private final StopConsolidationService stopConsolidationService;

    StopClusterMapper(TransitService transitService, @Nullable StopConsolidationService stopConsolidationService) {
        this.transitService = transitService;
        this.stopConsolidationService = stopConsolidationService;
    }

    Iterable<LuceneStopCluster> generateStopClusters(Collection<StopLocation> stopLocations, Collection<StopLocationsGroup> stopLocationsGroups) {
        List<LuceneStopCluster> stopClusters = this.buildStopClusters(stopLocations);
        List<LuceneStopCluster> stationClusters = StopClusterMapper.buildStationClusters(stopLocationsGroups);
        Iterable<LuceneStopCluster> consolidatedStopClusters = this.buildConsolidatedStopClusters();
        return Iterables.concat(stopClusters, stationClusters, consolidatedStopClusters);
    }

    private Iterable<LuceneStopCluster> buildConsolidatedStopClusters() {
        ImmutableListMultimap multiMap = (ImmutableListMultimap)this.stopConsolidationService.replacements().stream().collect(ImmutableListMultimap.toImmutableListMultimap(StopReplacement::primary, StopReplacement::secondary));
        return multiMap.keySet().stream().map(primary -> {
            ImmutableList secondaryIds = multiMap.get(primary);
            List<StopLocation> secondaries = secondaryIds.stream().map(this.transitService::getStopLocation).filter(Objects::nonNull).toList();
            List codes = ListUtils.combine((Collection[])new Collection[]{ListUtils.ofNullable((Object)primary.getCode()), StopClusterMapper.getCodes(secondaries)});
            List names = ListUtils.combine((Collection[])new Collection[]{ListUtils.ofNullable((Object)primary.getName()), StopClusterMapper.getNames(secondaries)});
            return new LuceneStopCluster(primary.getId().toString(), secondaryIds.stream().map(id -> id.toString()).toList(), names, codes, StopClusterMapper.toCoordinate(primary.getCoordinate()));
        }).toList();
    }

    private static List<LuceneStopCluster> buildStationClusters(Collection<StopLocationsGroup> stopLocationsGroups) {
        return stopLocationsGroups.stream().map(StopClusterMapper::map).toList();
    }

    private List<LuceneStopCluster> buildStopClusters(Collection<StopLocation> stopLocations) {
        List<StopLocation> stops = stopLocations.stream().filter(sl -> sl.getParentStation() == null).filter(sl -> !this.stopConsolidationService.isPartOfConsolidatedStop((StopLocation)sl)).filter(sl -> sl.getName() != null).toList();
        return stops.stream().collect(Collectors.groupingBy(sl -> new DeduplicationKey(sl.getName(), sl.getCoordinate().roundToApproximate10m()))).values().stream().map(group -> StopClusterMapper.map(group).orElse(null)).filter(Objects::nonNull).toList();
    }

    private static LuceneStopCluster map(StopLocationsGroup g) {
        Collection<StopLocation> childStops = g.getChildStops();
        List<String> ids = childStops.stream().map(s -> s.getId().toString()).toList();
        List<I18NString> childNames = StopClusterMapper.getNames(childStops);
        List<String> codes = StopClusterMapper.getCodes(childStops);
        return new LuceneStopCluster(g.getId().toString(), ids, ListUtils.combine((Collection[])new Collection[]{List.of(g.getName()), childNames}), codes, StopClusterMapper.toCoordinate(g.getCoordinate()));
    }

    private static List<String> getCodes(Collection<StopLocation> childStops) {
        return childStops.stream().map(StopLocation::getCode).filter(Objects::nonNull).toList();
    }

    private static List<I18NString> getNames(Collection<StopLocation> childStops) {
        return childStops.stream().map(StopLocation::getName).filter(Objects::nonNull).toList();
    }

    private static Optional<LuceneStopCluster> map(List<StopLocation> stopLocations) {
        StopLocation primary = stopLocations.getFirst();
        List<String> secondaryIds = stopLocations.stream().skip(1L).map(sl -> sl.getId().toString()).toList();
        List<I18NString> names = StopClusterMapper.getNames(stopLocations);
        List<String> codes = StopClusterMapper.getCodes(stopLocations);
        return Optional.ofNullable(primary.getName()).map(name -> new LuceneStopCluster(primary.getId().toString(), secondaryIds, names, codes, StopClusterMapper.toCoordinate(primary.getCoordinate())));
    }

    private List<Agency> agenciesForStopLocation(StopLocation stop) {
        return this.transitService.findRoutes(stop).stream().map(Route::getAgency).distinct().toList();
    }

    private List<Agency> agenciesForStopLocationsGroup(StopLocationsGroup group) {
        return group.getChildStops().stream().flatMap(sl -> this.agenciesForStopLocation((StopLocation)sl).stream()).distinct().toList();
    }

    StopCluster.Location toLocation(FeedScopedId id) {
        StopLocation loc = this.transitService.getStopLocation(id);
        if (loc != null) {
            StopCluster.FeedPublisher feedPublisher = StopClusterMapper.toFeedPublisher(this.transitService.getFeedInfo(id.getFeedId()));
            List<String> modes = this.transitService.findTransitModes(loc).stream().map(Enum::name).toList();
            List<StopCluster.Agency> agencies = this.agenciesForStopLocation(loc).stream().map(StopClusterMapper::toAgency).toList();
            return new StopCluster.Location(loc.getId(), loc.getCode(), StopCluster.LocationType.STOP, loc.getName().toString(), new StopCluster.Coordinate(loc.getLat(), loc.getLon()), modes, agencies, feedPublisher);
        }
        StopLocationsGroup group = this.transitService.getStopLocationsGroup(id);
        StopCluster.FeedPublisher feedPublisher = StopClusterMapper.toFeedPublisher(this.transitService.getFeedInfo(id.getFeedId()));
        List<String> modes = this.transitService.findTransitModes(group).stream().map(Enum::name).toList();
        List<StopCluster.Agency> agencies = this.agenciesForStopLocationsGroup(group).stream().map(StopClusterMapper::toAgency).toList();
        return new StopCluster.Location(group.getId(), StopClusterMapper.extractCode(group), StopCluster.LocationType.STATION, group.getName().toString(), new StopCluster.Coordinate(group.getLat(), group.getLon()), modes, agencies, feedPublisher);
    }

    @Nullable
    private static String extractCode(StopLocationsGroup group) {
        if (group instanceof Station) {
            Station station = (Station)group;
            return station.getCode();
        }
        return null;
    }

    private static StopCluster.Coordinate toCoordinate(WgsCoordinate c) {
        return new StopCluster.Coordinate(c.latitude(), c.longitude());
    }

    static StopCluster.Agency toAgency(Agency a) {
        return new StopCluster.Agency(a.getId(), a.getName());
    }

    private static StopCluster.FeedPublisher toFeedPublisher(FeedInfo fi) {
        if (fi == null) {
            return null;
        }
        return new StopCluster.FeedPublisher(fi.getPublisherName());
    }

    private record DeduplicationKey(I18NString name, WgsCoordinate coordinate) {
    }
}

