/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.geocoder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.framework.FeedScopedId;

record StopCluster(Location primary, Collection<Location> secondaries) {

    public record Location(@JsonSerialize(using=FeedScopedIdSerializer.class) FeedScopedId id, @Nullable String code, LocationType type, String name, Coordinate coordinate, Collection<String> modes, List<Agency> agencies, @Nullable FeedPublisher feedPublisher) {
        public Location {
            Objects.requireNonNull(id);
            Objects.requireNonNull(name);
            Objects.requireNonNull(type);
            Objects.requireNonNull(coordinate);
            Objects.requireNonNull(modes);
            Objects.requireNonNull(agencies);
        }
    }

    private static class FeedScopedIdSerializer
    extends JsonSerializer<FeedScopedId> {
        private FeedScopedIdSerializer() {
        }

        public void serialize(FeedScopedId value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    public static enum LocationType {
        STATION,
        STOP;

    }

    public record FeedPublisher(String name) {
    }

    public record Agency(@JsonSerialize(using=FeedScopedIdSerializer.class) FeedScopedId id, String name) {
    }

    public record Coordinate(double lat, double lon) {
    }
}

