/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.geocoder;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene101.Lucene101Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.suggest.document.Completion101PostingsFormat;
import org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.ContextQuery;
import org.apache.lucene.search.suggest.document.ContextSuggestField;
import org.apache.lucene.search.suggest.document.FuzzyCompletionQuery;
import org.apache.lucene.search.suggest.document.SuggestIndexSearcher;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.opentripplanner.ext.geocoder.EnglishNGramAnalyzer;
import org.opentripplanner.ext.geocoder.StopCluster;
import org.opentripplanner.ext.geocoder.StopClusterMapper;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationService;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.utils.collection.ListUtils;

public class LuceneIndex
implements Serializable {
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String SECONDARY_IDS = "secondary_ids";
    private static final String SUGGEST = "suggest";
    private static final String NAME = "name";
    private static final String NAME_NGRAM = "name_ngram";
    private static final String CODE = "code";
    private static final String LAT = "latitude";
    private static final String LON = "longitude";
    private final TransitService transitService;
    private final Analyzer analyzer;
    private final SuggestIndexSearcher searcher;
    private final StopClusterMapper stopClusterMapper;

    public LuceneIndex(TimetableRepository timetableRepository, StopConsolidationService stopConsolidationService) {
        this(new DefaultTransitService(timetableRepository), stopConsolidationService);
    }

    LuceneIndex(TransitService transitService, @Nullable StopConsolidationService stopConsolidationService) {
        this.transitService = transitService;
        this.stopClusterMapper = new StopClusterMapper(transitService, stopConsolidationService);
        this.analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), Map.ofEntries(Map.entry(NAME, new EnglishAnalyzer()), Map.entry(NAME_NGRAM, new EnglishNGramAnalyzer()), Map.entry(SUGGEST, new CompletionAnalyzer((Analyzer)new StandardAnalyzer()))));
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        try {
            try (IndexWriter directoryWriter = new IndexWriter((Directory)directory, LuceneIndex.iwcWithSuggestField(this.analyzer, Set.of(SUGGEST)));){
                transitService.listStopLocations().forEach(stopLocation -> LuceneIndex.addToIndex(directoryWriter, StopLocation.class, stopLocation.getId().toString(), List.of(), ListUtils.ofNullable((Object)stopLocation.getName()), ListUtils.ofNullable((Object)stopLocation.getCode()), stopLocation.getCoordinate().latitude(), stopLocation.getCoordinate().longitude()));
                transitService.listStopLocationGroups().forEach(stopLocationsGroup -> LuceneIndex.addToIndex(directoryWriter, StopLocationsGroup.class, stopLocationsGroup.getId().toString(), List.of(), ListUtils.ofNullable((Object)stopLocationsGroup.getName()), List.of(), stopLocationsGroup.getCoordinate().latitude(), stopLocationsGroup.getCoordinate().longitude()));
                this.stopClusterMapper.generateStopClusters(transitService.listStopLocations(), transitService.listStopLocationGroups()).forEach(stopCluster -> LuceneIndex.addToIndex(directoryWriter, StopCluster.class, stopCluster.primaryId(), stopCluster.secondaryIds(), stopCluster.names(), stopCluster.codes(), stopCluster.coordinate().lat(), stopCluster.coordinate().lon()));
            }
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            this.searcher = new SuggestIndexSearcher((IndexReader)indexReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<StopLocation> queryStopLocations(String query, boolean autocomplete) {
        return this.matchingDocuments(StopLocation.class, query, autocomplete).map(document -> this.transitService.getStopLocation(FeedScopedId.parse(document.get(ID))));
    }

    public Stream<StopLocationsGroup> queryStopLocationGroups(String query, boolean autocomplete) {
        return this.matchingDocuments(StopLocationsGroup.class, query, autocomplete).map(document -> this.transitService.getStopLocationsGroup(FeedScopedId.parse(document.get(ID))));
    }

    public Stream<StopCluster> queryStopClusters(String query) {
        return this.matchingDocuments(StopCluster.class, query, false).map(this::toStopCluster);
    }

    private StopCluster toStopCluster(Document document) {
        FeedScopedId primaryId = FeedScopedId.parse(document.get(ID));
        StopCluster.Location primary = this.stopClusterMapper.toLocation(primaryId);
        List<StopCluster.Location> secondaryIds = Arrays.stream(document.getValues(SECONDARY_IDS)).map(FeedScopedId::parse).map(this.stopClusterMapper::toLocation).toList();
        return new StopCluster(primary, secondaryIds);
    }

    static IndexWriterConfig iwcWithSuggestField(Analyzer analyzer, final Set<String> suggestFields) {
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        Lucene101Codec filterCodec = new Lucene101Codec(){
            final PostingsFormat postingsFormat = new Completion101PostingsFormat();

            public PostingsFormat getPostingsFormatForField(String field) {
                if (suggestFields.contains(field)) {
                    return this.postingsFormat;
                }
                return super.getPostingsFormatForField(field);
            }
        };
        iwc.setCodec((Codec)filterCodec);
        return iwc;
    }

    private static void addToIndex(IndexWriter writer, Class<?> type, String id, Collection<String> secondaryIds, Collection<I18NString> names, Collection<String> codes, double latitude, double longitude) {
        String typeName = type.getSimpleName();
        Document document = new Document();
        document.add((IndexableField)new StoredField(ID, id));
        for (String secondaryId : secondaryIds) {
            document.add((IndexableField)new StoredField(SECONDARY_IDS, secondaryId));
        }
        document.add((IndexableField)new TextField(TYPE, typeName, Field.Store.YES));
        for (I18NString name : names) {
            document.add((IndexableField)new TextField(NAME, Objects.toString(name), Field.Store.YES));
            document.add((IndexableField)new TextField(NAME_NGRAM, Objects.toString(name), Field.Store.YES));
            document.add((IndexableField)new ContextSuggestField(SUGGEST, Objects.toString(name), 1, new CharSequence[]{typeName}));
        }
        document.add((IndexableField)new StoredField(LAT, latitude));
        document.add((IndexableField)new StoredField(LON, longitude));
        for (String code : codes) {
            document.add((IndexableField)new TextField(CODE, code, Field.Store.YES));
            document.add((IndexableField)new ContextSuggestField(SUGGEST, code, 1, new CharSequence[]{typeName}));
        }
        try {
            writer.addDocument((Iterable)document);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Stream<Document> matchingDocuments(Class<?> type, String searchTerms, boolean autocomplete) {
        searchTerms = searchTerms.strip();
        try {
            if (autocomplete) {
                FuzzyCompletionQuery completionQuery = new FuzzyCompletionQuery(this.analyzer, new Term(SUGGEST, this.analyzer.normalize(SUGGEST, searchTerms)), null, 2, true, 4, 3, true, 3);
                ContextQuery query = new ContextQuery((CompletionQuery)completionQuery);
                query.addContext((CharSequence)type.getSimpleName());
                TopSuggestDocs topDocs = this.searcher.suggest((CompletionQuery)query, 25, true);
                return Arrays.stream(topDocs.scoreDocs).map(scoreDoc -> {
                    try {
                        return this.searcher.storedFields().document(scoreDoc.doc);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            QueryParser nameParser = new QueryParser(NAME_NGRAM, this.analyzer);
            Query nameQuery = nameParser.parse(searchTerms);
            TermQuery ngramNameQuery = new TermQuery(new Term(NAME_NGRAM, this.analyzer.normalize(NAME_NGRAM, searchTerms)));
            FuzzyQuery fuzzyNameQuery = new FuzzyQuery(new Term(NAME, this.analyzer.normalize(NAME, searchTerms)));
            PrefixQuery prefixNameQuery = new PrefixQuery(new Term(NAME, this.analyzer.normalize(NAME, searchTerms)));
            TermQuery codeQuery = new TermQuery(new Term(CODE, this.analyzer.normalize(CODE, searchTerms)));
            PrefixQuery prefixCodeQuery = new PrefixQuery(new Term(CODE, this.analyzer.normalize(CODE, searchTerms)));
            TermQuery typeQuery = new TermQuery(new Term(TYPE, this.analyzer.normalize(TYPE, type.getSimpleName())));
            BooleanQuery.Builder builder = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add((Query)typeQuery, BooleanClause.Occur.MUST).add((Query)codeQuery, BooleanClause.Occur.SHOULD).add((Query)prefixCodeQuery, BooleanClause.Occur.SHOULD).add(nameQuery, BooleanClause.Occur.SHOULD).add((Query)fuzzyNameQuery, BooleanClause.Occur.SHOULD).add((Query)prefixNameQuery, BooleanClause.Occur.SHOULD).add((Query)ngramNameQuery, BooleanClause.Occur.SHOULD);
            BooleanQuery query = builder.build();
            TopDocs topDocs = this.searcher.search((Query)query, 25);
            return Arrays.stream(topDocs.scoreDocs).map(scoreDoc -> {
                try {
                    return this.searcher.storedFields().document(scoreDoc.doc);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException | ParseException ex) {
            throw new RuntimeException(ex);
        }
    }
}

