/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.geocoder;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.geocoder.StopCluster;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.model.site.StopLocation;

@Path(value="/geocode")
@Produces(value={"application/json"})
public class GeocoderResource {
    private final LuceneIndex luceneIndex;

    public GeocoderResource(@Context OtpServerRequestContext requestContext) {
        this.luceneIndex = requestContext.lucenceIndex();
    }

    @GET
    public Response textSearch(@QueryParam(value="query") String query, @QueryParam(value="autocomplete") @DefaultValue(value="false") boolean autocomplete, @QueryParam(value="stops") @DefaultValue(value="true") boolean stops, @QueryParam(value="clusters") @DefaultValue(value="false") boolean clusters) {
        return Response.status((Response.Status)Response.Status.OK).entity(this.query(query, autocomplete, stops, clusters)).build();
    }

    @GET
    @Path(value="stopClusters")
    public Response stopClusters(@QueryParam(value="query") String query) {
        List<StopCluster> clusters = this.luceneIndex.queryStopClusters(query).toList();
        return Response.status((Response.Status)Response.Status.OK).entity(clusters).build();
    }

    private List<SearchResult> query(String query, boolean autocomplete, boolean stops, boolean clusters) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        if (stops) {
            results.addAll(this.queryStopLocations(query, autocomplete));
        }
        if (clusters) {
            results.addAll(this.queryStations(query, autocomplete));
        }
        return results;
    }

    private Collection<SearchResult> queryStopLocations(String query, boolean autocomplete) {
        return this.luceneIndex.queryStopLocations(query, autocomplete).map(sl -> new SearchResult(sl.getCoordinate().latitude(), sl.getCoordinate().longitude(), this.stringifyStopLocation((StopLocation)sl), sl.getId().toString())).collect(Collectors.toList());
    }

    private Collection<? extends SearchResult> queryStations(String query, boolean autocomplete) {
        return this.luceneIndex.queryStopLocationGroups(query, autocomplete).map(sc -> new SearchResult(sc.getCoordinate().latitude(), sc.getCoordinate().longitude(), Objects.toString(sc.getName()), sc.getId().toString())).collect(Collectors.toList());
    }

    private String stringifyStopLocation(StopLocation sl) {
        return sl.getCode() != null ? String.format("%s (%s)", sl.getName(), sl.getCode()) : Objects.toString(sl.getName());
    }

    public static class SearchResult {
        public double lat;
        public double lng;
        public String description;
        public String id;

        private SearchResult(double lat, double lng, String description, String id) {
            this.lat = lat;
            this.lng = lng;
            this.description = description;
            this.id = id;
        }
    }

    @Path(value="/routers/{ignoreRouterId}/geocode")
    public static class GeocoderResourceOldPath
    extends GeocoderResource {
        public GeocoderResourceOldPath(@Context OtpServerRequestContext serverContext, @PathParam(value="ignoreRouterId") String ignore) {
            super(serverContext);
        }
    }
}

