/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.geocoder;

import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.miscellaneous.CapitalizationFilter;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.lucene.analysis.pattern.PatternReplaceFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

class EnglishNGramAnalyzer
extends Analyzer {
    private static final Pattern NUMBER_SUFFIX_PATTERN = Pattern.compile("(\\d+)(st|nd|rd|th)\\b");

    EnglishNGramAnalyzer() {
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer src = new StandardTokenizer();
        EnglishPossessiveFilter result = new EnglishPossessiveFilter((TokenStream)src);
        result = new LowerCaseFilter((TokenStream)result);
        result = new PatternReplaceFilter((TokenStream)result, NUMBER_SUFFIX_PATTERN, "$1", true);
        result = new StopFilter((TokenStream)result, EnglishAnalyzer.ENGLISH_STOP_WORDS_SET);
        result = new PorterStemFilter((TokenStream)result);
        result = new CapitalizationFilter((TokenStream)result);
        result = new NGramTokenFilter((TokenStream)result, 4, 10, true);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)result);
    }
}

