/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.TimePenaltyCalculator;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.flex.trip.StopTimeWindow;
import org.opentripplanner.ext.flex.trip.UnscheduledTripBuilder;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.routing.api.request.framework.TimePenalty;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.TransitBuilder;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.lang.IntRange;
import org.opentripplanner.utils.time.DurationUtils;

public class UnscheduledTrip
extends FlexTrip<UnscheduledTrip, UnscheduledTripBuilder> {
    private final StopTimeWindow[] stopTimes;
    private final BookingInfo[] dropOffBookingInfos;
    private final BookingInfo[] pickupBookingInfos;
    private final TimePenalty timePenalty;

    public UnscheduledTrip(UnscheduledTripBuilder builder) {
        super(builder);
        List<StopTime> stopTimes = builder.stopTimes();
        if (!UnscheduledTrip.isUnscheduledTrip(stopTimes)) {
            throw new IllegalArgumentException("Incompatible stopTimes for unscheduled trip");
        }
        int size = stopTimes.size();
        this.stopTimes = new StopTimeWindow[size];
        this.dropOffBookingInfos = new BookingInfo[size];
        this.pickupBookingInfos = new BookingInfo[size];
        for (int i = 0; i < size; ++i) {
            this.stopTimes[i] = new StopTimeWindow(stopTimes.get(i));
            this.dropOffBookingInfos[i] = stopTimes.get(i).getDropOffBookingInfo();
            this.pickupBookingInfos[i] = stopTimes.get(i).getPickupBookingInfo();
        }
        this.timePenalty = Objects.requireNonNull(builder.timePenalty());
        DurationUtils.requireNonNegative((Duration)((Duration)this.timePenalty.constant()));
        DoubleUtils.requireInRange((double)this.timePenalty.coefficient(), (double)0.05, (double)Double.MAX_VALUE);
    }

    public static UnscheduledTripBuilder of(FeedScopedId id) {
        return new UnscheduledTripBuilder(id);
    }

    public static boolean isUnscheduledTrip(List<StopTime> stopTimes) {
        if (stopTimes.size() < 2) {
            return false;
        }
        if (stopTimes.stream().anyMatch(StopTime::combinesContinuousStoppingWithFlexWindow)) {
            return false;
        }
        if (stopTimes.size() == 2) {
            return stopTimes.stream().anyMatch(StopTime::hasFlexWindow);
        }
        return stopTimes.stream().allMatch(StopTime::hasFlexWindow);
    }

    @Override
    public int earliestDepartureTime(int requestedDepartureTime, int boardStopPosition, int alightStopPosition, int tripDurationSeconds) {
        Optional<IntRange> optionalDepartureTimeWindow = this.departureTimeWindow(boardStopPosition, alightStopPosition, tripDurationSeconds);
        if (optionalDepartureTimeWindow.isEmpty()) {
            return -999;
        }
        IntRange win = optionalDepartureTimeWindow.get();
        if (win.endInclusive() < requestedDepartureTime) {
            return -999;
        }
        return Math.max(requestedDepartureTime, win.startInclusive());
    }

    @Override
    public int earliestDepartureTime(int stopIndex) {
        return this.stopTimes[stopIndex].start();
    }

    @Override
    public int latestArrivalTime(int requestedArrivalTime, int boardStopPosition, int alightStopPosition, int tripDurationSeconds) {
        Optional<IntRange> optionalArrivalTimeWindow = this.arrivalTimeWindow(boardStopPosition, alightStopPosition, tripDurationSeconds);
        if (optionalArrivalTimeWindow.isEmpty()) {
            return -999;
        }
        IntRange win = optionalArrivalTimeWindow.get();
        if (win.startInclusive() > requestedArrivalTime) {
            return -999;
        }
        return Math.min(requestedArrivalTime, win.endInclusive());
    }

    @Override
    public int latestArrivalTime(int stopIndex) {
        return this.stopTimes[stopIndex].end();
    }

    @Override
    public int numberOfStops() {
        return this.stopTimes.length;
    }

    @Override
    public Set<StopLocation> getStops() {
        return Arrays.stream(this.stopTimes).map(StopTimeWindow::stop).collect(Collectors.toSet());
    }

    @Override
    public StopLocation getStop(int stopIndex) {
        return this.stopTimes[stopIndex].stop();
    }

    @Override
    public BookingInfo getDropOffBookingInfo(int stopIndex) {
        return this.dropOffBookingInfos[stopIndex];
    }

    @Override
    public BookingInfo getPickupBookingInfo(int stopIndex) {
        return this.pickupBookingInfos[stopIndex];
    }

    @Override
    public PickDrop getBoardRule(int stopIndex) {
        return this.stopTimes[stopIndex].pickupType();
    }

    @Override
    public PickDrop getAlightRule(int stopIndex) {
        return this.stopTimes[stopIndex].dropOffType();
    }

    @Override
    public boolean isBoardingPossible(StopLocation stop) {
        return this.findBoardIndex(stop) != STOP_INDEX_NOT_FOUND;
    }

    @Override
    public boolean isAlightingPossible(StopLocation stop) {
        return this.findAlightIndex(stop) != STOP_INDEX_NOT_FOUND;
    }

    @Override
    public boolean sameAs(UnscheduledTrip other) {
        return super.sameAs(other) && Arrays.equals(this.stopTimes, other.stopTimes) && Arrays.equals(this.pickupBookingInfos, other.pickupBookingInfos) && Arrays.equals(this.dropOffBookingInfos, other.dropOffBookingInfos);
    }

    @Override
    public TransitBuilder<UnscheduledTrip, UnscheduledTripBuilder> copy() {
        return new UnscheduledTripBuilder(this);
    }

    @Override
    public int findBoardIndex(StopLocation fromStop) {
        for (int i = 0; i < this.stopTimes.length; ++i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getBoardRule(i).isNotRoutable() || !((stop = this.stopTimes[i].stop()) instanceof GroupStop ? (groupStop = (GroupStop)stop).getChildLocations().contains(fromStop) : stop.equals(fromStop))) continue;
            return i;
        }
        return FlexTrip.STOP_INDEX_NOT_FOUND;
    }

    @Override
    public int findAlightIndex(StopLocation toStop) {
        for (int i = this.stopTimes.length - 1; i >= 0; --i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getAlightRule(i).isNotRoutable() || !((stop = this.stopTimes[i].stop()) instanceof GroupStop ? (groupStop = (GroupStop)stop).getChildLocations().contains(toStop) : stop.equals(toStop))) continue;
            return i;
        }
        return FlexTrip.STOP_INDEX_NOT_FOUND;
    }

    @Override
    public FlexPathCalculator decorateFlexPathCalculator(FlexPathCalculator defaultCalculator) {
        if (this.timePenalty.modifies()) {
            return new TimePenaltyCalculator(defaultCalculator, this.timePenalty);
        }
        return defaultCalculator;
    }

    private Optional<IntRange> departureTimeWindow(int boardStopPosition, int alightStopPosition, int tripDurationSeconds) {
        IntRange fromTime = this.stopTimes[boardStopPosition].timeWindow();
        IntRange toTimeShifted = this.stopTimes[alightStopPosition].timeWindow().minus(tripDurationSeconds);
        return fromTime.intersect(toTimeShifted);
    }

    private Optional<IntRange> arrivalTimeWindow(int boardStopPosition, int alightStopPosition, int tripDurationSeconds) {
        IntRange fromTimeShifted = this.stopTimes[boardStopPosition].timeWindow().plus(tripDurationSeconds);
        IntRange toTime = this.stopTimes[alightStopPosition].timeWindow();
        return toTime.intersect(fromTimeShifted);
    }

    private record IndexedStopLocation(int index, StopLocation stop) {
    }
}

