/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.io.Serializable;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.lang.IntRange;

class StopTimeWindow
implements Serializable {
    private final StopLocation stop;
    private final int start;
    private final int end;
    private final PickDrop pickupType;
    private final PickDrop dropOffType;

    StopTimeWindow(StopTime st) {
        this.stop = st.getStop();
        int earliestPossibleDepartureTime = st.getEarliestPossibleDepartureTime();
        int latestPossibleArrivalTime = st.getLatestPossibleArrivalTime();
        this.start = StopTimeWindow.getAvailableTime(earliestPossibleDepartureTime, latestPossibleArrivalTime);
        this.end = StopTimeWindow.getAvailableTime(latestPossibleArrivalTime, earliestPossibleDepartureTime);
        this.pickupType = this.start == -999 ? PickDrop.NONE : st.getPickupType();
        this.dropOffType = this.end == -999 ? PickDrop.NONE : st.getDropOffType();
    }

    public StopLocation stop() {
        return this.stop;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public PickDrop pickupType() {
        return this.pickupType;
    }

    public PickDrop dropOffType() {
        return this.dropOffType;
    }

    public IntRange timeWindow() {
        return IntRange.ofInclusive((int)this.start, (int)this.end);
    }

    private static int getAvailableTime(int ... times) {
        for (int time : times) {
            if (time == -999) continue;
            return time;
        }
        return -999;
    }
}

