/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.ScheduledFlexPathCalculator;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.flex.trip.ScheduledDeviatedTripBuilder;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.TransitBuilder;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;

public class ScheduledDeviatedTrip
extends FlexTrip<ScheduledDeviatedTrip, ScheduledDeviatedTripBuilder> {
    private final ScheduledDeviatedStopTime[] stopTimes;
    private final BookingInfo[] dropOffBookingInfos;
    private final BookingInfo[] pickupBookingInfos;

    ScheduledDeviatedTrip(ScheduledDeviatedTripBuilder builder) {
        super(builder);
        List<StopTime> stopTimes = builder.stopTimes();
        if (!ScheduledDeviatedTrip.isScheduledDeviatedFlexTrip(stopTimes)) {
            throw new IllegalArgumentException("Incompatible stopTimes for scheduled flex trip");
        }
        int nStops = stopTimes.size();
        this.stopTimes = new ScheduledDeviatedStopTime[nStops];
        this.dropOffBookingInfos = new BookingInfo[nStops];
        this.pickupBookingInfos = new BookingInfo[nStops];
        for (int i = 0; i < nStops; ++i) {
            this.stopTimes[i] = new ScheduledDeviatedStopTime(stopTimes.get(i));
            this.dropOffBookingInfos[i] = stopTimes.get(i).getDropOffBookingInfo();
            this.pickupBookingInfos[i] = stopTimes.get(i).getPickupBookingInfo();
        }
    }

    public static ScheduledDeviatedTripBuilder of(FeedScopedId id) {
        return new ScheduledDeviatedTripBuilder(id);
    }

    public static boolean isScheduledDeviatedFlexTrip(List<StopTime> stopTimes) {
        return stopTimes.size() >= 2 && stopTimes.stream().anyMatch(StopTime::hasFlexibleStop) && stopTimes.stream().noneMatch(StopTime::combinesContinuousStoppingWithFlexWindow);
    }

    @Override
    public int earliestDepartureTime(int departureTime, int boardStopPosition, int alightStopPosition, int flexTripDurationSeconds) {
        int stopTime = -999;
        for (int i = boardStopPosition; stopTime == -999 && i >= 0; --i) {
            stopTime = this.stopTimes[i].departureTime;
        }
        return stopTime >= departureTime ? stopTime : -999;
    }

    @Override
    public int earliestDepartureTime(int stopIndex) {
        return this.stopTimes[stopIndex].departureTime;
    }

    @Override
    public int latestArrivalTime(int arrivalTime, int boardStopPosition, int alightStopPosition, int flexTripDurationSeconds) {
        int stopTime = -999;
        for (int i = alightStopPosition; stopTime == -999 && i < this.stopTimes.length; ++i) {
            stopTime = this.stopTimes[i].arrivalTime;
        }
        return stopTime <= arrivalTime ? stopTime : -999;
    }

    @Override
    public int latestArrivalTime(int stopIndex) {
        return this.stopTimes[stopIndex].arrivalTime;
    }

    @Override
    public int numberOfStops() {
        return this.stopTimes.length;
    }

    @Override
    public Set<StopLocation> getStops() {
        return Arrays.stream(this.stopTimes).map(scheduledDeviatedStopTime -> scheduledDeviatedStopTime.stop).collect(Collectors.toSet());
    }

    @Override
    public StopLocation getStop(int stopIndex) {
        return this.stopTimes[stopIndex].stop;
    }

    @Override
    public BookingInfo getDropOffBookingInfo(int i) {
        return this.dropOffBookingInfos[i];
    }

    @Override
    public BookingInfo getPickupBookingInfo(int i) {
        return this.pickupBookingInfos[i];
    }

    @Override
    public PickDrop getBoardRule(int i) {
        return this.stopTimes[i].pickupType;
    }

    @Override
    public PickDrop getAlightRule(int i) {
        return this.stopTimes[i].dropOffType;
    }

    @Override
    public boolean isBoardingPossible(StopLocation fromStop) {
        return this.findBoardIndex(fromStop) != STOP_INDEX_NOT_FOUND;
    }

    @Override
    public boolean isAlightingPossible(StopLocation toStop) {
        return this.findAlightIndex(toStop) != STOP_INDEX_NOT_FOUND;
    }

    @Override
    public boolean sameAs(ScheduledDeviatedTrip other) {
        return super.sameAs(other) && Arrays.equals(this.stopTimes, other.stopTimes) && Arrays.equals(this.pickupBookingInfos, other.pickupBookingInfos) && Arrays.equals(this.dropOffBookingInfos, other.dropOffBookingInfos);
    }

    @Override
    public TransitBuilder<ScheduledDeviatedTrip, ScheduledDeviatedTripBuilder> copy() {
        return new ScheduledDeviatedTripBuilder(this);
    }

    @Override
    public int findBoardIndex(StopLocation fromStop) {
        for (int i = 0; i < this.stopTimes.length; ++i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getBoardRule(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof GroupStop ? (groupStop = (GroupStop)stop).getChildLocations().contains(fromStop) : stop.equals(fromStop))) continue;
            return i;
        }
        return STOP_INDEX_NOT_FOUND;
    }

    @Override
    public int findAlightIndex(StopLocation toStop) {
        for (int i = this.stopTimes.length - 1; i >= 0; --i) {
            GroupStop groupStop;
            StopLocation stop;
            if (this.getAlightRule(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof GroupStop ? (groupStop = (GroupStop)stop).getChildLocations().contains(toStop) : stop.equals(toStop))) continue;
            return i;
        }
        return STOP_INDEX_NOT_FOUND;
    }

    @Override
    public FlexPathCalculator decorateFlexPathCalculator(FlexPathCalculator defaultCalculator) {
        return new ScheduledFlexPathCalculator(defaultCalculator, this);
    }

    private static class ScheduledDeviatedStopTime
    implements Serializable {
        private final StopLocation stop;
        private final int departureTime;
        private final int arrivalTime;
        private final PickDrop pickupType;
        private final PickDrop dropOffType;

        private ScheduledDeviatedStopTime(StopTime st) {
            this.stop = st.getStop();
            this.arrivalTime = st.getLatestPossibleArrivalTime();
            this.departureTime = st.getEarliestPossibleDepartureTime();
            this.pickupType = this.departureTime == -999 ? PickDrop.NONE : st.getPickupType();
            this.dropOffType = this.arrivalTime == -999 ? PickDrop.NONE : st.getDropOffType();
        }
    }
}

