/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.trip.FlexTripBuilder;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;

public abstract class FlexTrip<T extends FlexTrip<T, B>, B extends FlexTripBuilder<T, B>>
extends AbstractTransitEntity<T, B> {
    public static int STOP_INDEX_NOT_FOUND = -1;
    private final Trip trip;

    FlexTrip(FlexTripBuilder<T, B> builder) {
        super(builder.getId());
        this.trip = builder.trip();
    }

    public static boolean containsFlexStops(List<StopTime> stopTimes) {
        return stopTimes.stream().map(StopTime::getStop).anyMatch(FlexTrip::isFlexStop);
    }

    public static boolean isFlexStop(StopLocation stop) {
        return stop instanceof GroupStop || stop instanceof AreaStop;
    }

    public abstract int earliestDepartureTime(int var1, int var2, int var3, int var4);

    public abstract int earliestDepartureTime(int var1);

    public abstract int latestArrivalTime(int var1, int var2, int var3, int var4);

    public abstract int latestArrivalTime(int var1);

    public abstract int numberOfStops();

    public abstract Set<StopLocation> getStops();

    public abstract StopLocation getStop(int var1);

    public Trip getTrip() {
        return this.trip;
    }

    public abstract BookingInfo getDropOffBookingInfo(int var1);

    public abstract BookingInfo getPickupBookingInfo(int var1);

    public abstract PickDrop getBoardRule(int var1);

    public abstract PickDrop getAlightRule(int var1);

    public abstract boolean isBoardingPossible(StopLocation var1);

    public abstract boolean isAlightingPossible(StopLocation var1);

    public abstract int findBoardIndex(StopLocation var1);

    public abstract int findAlightIndex(StopLocation var1);

    public abstract FlexPathCalculator decorateFlexPathCalculator(FlexPathCalculator var1);

    @Override
    public boolean sameAs(T other) {
        return this.getId().equals(((AbstractTransitEntity)other).getId()) && Objects.equals(this.trip, ((FlexTrip)other).getTrip());
    }
}

