/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.ClosestTrip;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.template.FlexServiceDate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.booking.RoutingBookingInfo;

class FlexTemplateFactory {
    private final FlexPathCalculator calculator;
    private final Duration maxTransferDuration;
    private NearbyStop nearbyStop;
    private int stopPos;
    private FlexTrip<?, ?> trip;
    private FlexServiceDate date;

    private FlexTemplateFactory(FlexPathCalculator calculator, Duration maxTransferDuration) {
        this.calculator = Objects.requireNonNull(calculator);
        this.maxTransferDuration = Objects.requireNonNull(maxTransferDuration);
    }

    static FlexTemplateFactory of(FlexPathCalculator calculator, Duration maxTransferDuration) {
        return new FlexTemplateFactory(calculator, maxTransferDuration);
    }

    List<FlexAccessTemplate> createAccessTemplates(ClosestTrip closestTrip) {
        return this.with(closestTrip).createAccessTemplates();
    }

    List<FlexEgressTemplate> createEgressTemplates(ClosestTrip closestTrip) {
        return this.with(closestTrip).createEgressTemplates();
    }

    private FlexTemplateFactory with(ClosestTrip closestTrip) {
        this.nearbyStop = closestTrip.nearbyStop();
        this.stopPos = closestTrip.stopPos();
        this.trip = closestTrip.flexTrip();
        this.date = closestTrip.activeDate();
        return this;
    }

    private List<FlexAccessTemplate> createAccessTemplates() {
        int alightStopPos;
        int boardStopPos = this.stopPos;
        ArrayList<FlexAccessTemplate> result = new ArrayList<FlexAccessTemplate>();
        int n = alightStopPos = this.isBoardingAndAlightingAtSameStopPositionAllowed() ? boardStopPos : boardStopPos + 1;
        while (alightStopPos < this.trip.numberOfStops()) {
            if (this.trip.getAlightRule(alightStopPos).isRoutable()) {
                for (StopLocation stop : FlexTemplateFactory.expandStopsAt(this.trip, alightStopPos)) {
                    result.add(this.createAccessTemplate(this.trip, boardStopPos, stop, alightStopPos));
                }
            }
            ++alightStopPos;
        }
        return result;
    }

    private List<FlexEgressTemplate> createEgressTemplates() {
        int alightStopPos = this.stopPos;
        ArrayList<FlexEgressTemplate> result = new ArrayList<FlexEgressTemplate>();
        int end = this.isBoardingAndAlightingAtSameStopPositionAllowed() ? alightStopPos : alightStopPos - 1;
        for (int boardStopPos = 0; boardStopPos <= end; ++boardStopPos) {
            if (!this.isAllowedToBoardAt(boardStopPos)) continue;
            for (StopLocation stop : FlexTemplateFactory.expandStopsAt(this.trip, boardStopPos)) {
                result.add(this.createEgressTemplate(this.trip, stop, boardStopPos, alightStopPos));
            }
        }
        return result;
    }

    private boolean isAllowedToBoardAt(int boardStopPosition) {
        return this.trip.getBoardRule(boardStopPosition).isRoutable() && !RoutingBookingInfo.of(this.date.requestedBookingTime(), this.trip.getPickupBookingInfo(boardStopPosition)).exceedsLatestBookingTime();
    }

    private boolean isBoardingAndAlightingAtSameStopPositionAllowed() {
        return false;
    }

    private static List<StopLocation> expandStopsAt(FlexTrip<?, ?> flexTrip, int index) {
        List<StopLocation> list;
        StopLocation stop = flexTrip.getStop(index);
        if (stop instanceof GroupStop) {
            GroupStop groupStop = (GroupStop)stop;
            list = groupStop.getChildLocations();
        } else {
            list = List.of(stop);
        }
        return list;
    }

    private FlexAccessTemplate createAccessTemplate(FlexTrip<?, ?> flexTrip, int boardStopPosition, StopLocation alightStop, int alightStopPosition) {
        return new FlexAccessTemplate(flexTrip, this.nearbyStop, boardStopPosition, alightStop, alightStopPosition, this.date, this.setupCalculator(flexTrip), this.maxTransferDuration);
    }

    private FlexEgressTemplate createEgressTemplate(FlexTrip<?, ?> flexTrip, StopLocation boardStop, int boardStopPosition, int alightStopPosition) {
        return new FlexEgressTemplate(flexTrip, boardStop, boardStopPosition, this.nearbyStop, alightStopPosition, this.date, this.setupCalculator(flexTrip), this.maxTransferDuration);
    }

    private FlexPathCalculator setupCalculator(FlexTrip<?, ?> flexTrip) {
        return flexTrip.decorateFlexPathCalculator(this.calculator);
    }
}

