/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.flex.FlexPathDurations;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.AbstractFlexTemplate;
import org.opentripplanner.ext.flex.template.FlexAccessEgressCallbackAdapter;
import org.opentripplanner.ext.flex.template.FlexServiceDate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;

class FlexEgressTemplate
extends AbstractFlexTemplate {
    FlexEgressTemplate(FlexTrip<?, ?> trip, StopLocation boardStop, int boardStopPosition, NearbyStop alightStop, int alightStopPosition, FlexServiceDate date, FlexPathCalculator calculator, Duration maxTransferDuration) {
        super(trip, alightStop, boardStop, boardStopPosition, alightStopPosition, date, calculator, maxTransferDuration);
    }

    @Override
    protected List<Edge> getTransferEdges(PathTransfer transfer) {
        return Lists.reverse(transfer.getEdges());
    }

    @Override
    protected RegularStop getFinalStop(PathTransfer transfer) {
        RegularStop regularStop;
        StopLocation stopLocation = transfer.from;
        return stopLocation instanceof RegularStop ? (regularStop = (RegularStop)stopLocation) : null;
    }

    @Override
    protected Collection<PathTransfer> getTransfersFromTransferStop(FlexAccessEgressCallbackAdapter callback) {
        return callback.getTransfersToStop(this.transferStop);
    }

    @Override
    protected Vertex getFlexVertex(Edge edge) {
        return edge.getToVertex();
    }

    @Override
    protected FlexPathDurations calculateFlexPathDurations(FlexTripEdge flexEdge, State state) {
        int postFlexTime = (int)this.accessEgress.state.getElapsedTimeSeconds();
        int edgeTimeInSeconds = flexEdge.getTimeInSeconds();
        int preFlexTime = (int)state.getElapsedTimeSeconds() - postFlexTime - edgeTimeInSeconds;
        return new FlexPathDurations(preFlexTime, edgeTimeInSeconds, postFlexTime, this.secondsFromStartOfTime);
    }

    @Override
    protected FlexTripEdge getFlexEdge(Vertex flexFromVertex, StopLocation transferStop) {
        FlexPath flexPath = this.calculator.calculateFlexPath(flexFromVertex, this.accessEgress.state.getVertex(), this.boardStopPosition, this.alightStopPosition);
        if (flexPath == null) {
            return null;
        }
        return new FlexTripEdge(flexFromVertex, this.accessEgress.state.getVertex(), transferStop, this.accessEgress.stop, this.trip, this.boardStopPosition, this.alightStopPosition, this.serviceDate, flexPath);
    }
}

