/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.opentripplanner.ext.flex.FlexPathDurations;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.DirectFlexPath;
import org.opentripplanner.ext.flex.template.FlexAccessEgressCallbackAdapter;
import org.opentripplanner.ext.flex.template.FlexAccessFactory;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressFactory;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.template.FlexServiceDate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.EdgeTraverser;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.transit.model.timetable.booking.RoutingBookingInfo;

public class FlexDirectPathFactory {
    private final FlexAccessEgressCallbackAdapter callbackService;
    private final FlexPathCalculator accessPathCalculator;
    private final FlexPathCalculator egressPathCalculator;
    private final Duration maxTransferDuration;
    private final Matcher<Trip> matcher;

    public FlexDirectPathFactory(FlexAccessEgressCallbackAdapter callbackService, FlexPathCalculator accessPathCalculator, FlexPathCalculator egressPathCalculator, Duration maxTransferDuration, Matcher<Trip> matcher) {
        this.callbackService = callbackService;
        this.accessPathCalculator = accessPathCalculator;
        this.egressPathCalculator = egressPathCalculator;
        this.maxTransferDuration = maxTransferDuration;
        this.matcher = matcher;
    }

    public Collection<DirectFlexPath> calculateDirectFlexPaths(Collection<NearbyStop> streetAccesses, Collection<NearbyStop> streetEgresses, List<FlexServiceDate> dates, int requestTime, boolean arriveBy) {
        ArrayList<DirectFlexPath> directFlexPaths = new ArrayList<DirectFlexPath>();
        List<FlexAccessTemplate> flexAccessTemplates = new FlexAccessFactory(this.callbackService, this.accessPathCalculator, this.maxTransferDuration, this.matcher).calculateFlexAccessTemplates(streetAccesses, dates);
        List<FlexEgressTemplate> flexEgressTemplates = new FlexEgressFactory(this.callbackService, this.egressPathCalculator, this.maxTransferDuration, this.matcher).calculateFlexEgressTemplates(streetEgresses, dates);
        HashMultimap streetEgressByStop = HashMultimap.create();
        streetEgresses.forEach(arg_0 -> FlexDirectPathFactory.lambda$calculateDirectFlexPaths$0((Multimap)streetEgressByStop, arg_0));
        for (FlexAccessTemplate template : flexAccessTemplates) {
            StopLocation transferStop = template.getTransferStop();
            if (!flexEgressTemplates.stream().anyMatch(t -> t.getAccessEgressStop().equals(transferStop))) continue;
            for (NearbyStop egress : streetEgressByStop.get((Object)transferStop)) {
                this.createDirectGraphPath(template, egress, arriveBy, requestTime).ifPresent(directFlexPaths::add);
            }
        }
        return directFlexPaths;
    }

    private Optional<DirectFlexPath> createDirectGraphPath(FlexAccessTemplate accessTemplate, NearbyStop egress, boolean arriveBy, int requestTime) {
        int timeShift;
        NearbyStop accessNearbyStop = accessTemplate.accessEgress;
        FlexTrip trip = accessTemplate.trip;
        int accessBoardStopPosition = accessTemplate.boardStopPosition;
        int accessAlightStopPosition = accessTemplate.alightStopPosition;
        int requestedBookingTime = accessTemplate.requestedBookingTime;
        Vertex flexToVertex = egress.state.getVertex();
        if (!this.isRouteable(accessTemplate, flexToVertex)) {
            return Optional.empty();
        }
        FlexTripEdge flexEdge = accessTemplate.getFlexEdge(flexToVertex, egress.stop);
        if (flexEdge == null) {
            return Optional.empty();
        }
        State[] afterFlexState = flexEdge.traverse(accessNearbyStop.state);
        Optional<State> finalStateOpt = EdgeTraverser.traverseEdges(afterFlexState[0], egress.edges);
        if (finalStateOpt.isEmpty()) {
            return Optional.empty();
        }
        State finalState = finalStateOpt.get();
        FlexPathDurations flexDurations = accessTemplate.calculateFlexPathDurations(flexEdge, finalState);
        if (arriveBy) {
            int lastStopArrivalTime = flexDurations.mapToFlexTripArrivalTime(requestTime);
            int latestArrivalTime = trip.latestArrivalTime(lastStopArrivalTime, accessBoardStopPosition, accessAlightStopPosition, flexDurations.trip());
            if (latestArrivalTime == -999) {
                return Optional.empty();
            }
            RoutingBookingInfo bookingInfo = RoutingBookingInfo.of(requestedBookingTime, trip.getPickupBookingInfo(accessTemplate.boardStopPosition));
            if (bookingInfo.exceedsMinimumBookingNotice(latestArrivalTime)) {
                return Optional.empty();
            }
            timeShift = flexDurations.mapToRouterArrivalTime(latestArrivalTime) - flexDurations.total();
        } else {
            int firstStopDepartureTime = flexDurations.mapToFlexTripDepartureTime(requestTime);
            BookingInfo bookingInfo = trip.getPickupBookingInfo(accessBoardStopPosition);
            firstStopDepartureTime = RoutingBookingInfo.of(requestedBookingTime, bookingInfo).earliestDepartureTime(firstStopDepartureTime);
            int earliestDepartureTime = trip.earliestDepartureTime(firstStopDepartureTime, accessBoardStopPosition, accessAlightStopPosition, flexDurations.trip());
            if (earliestDepartureTime == -999) {
                return Optional.empty();
            }
            timeShift = flexDurations.mapToRouterDepartureTime(earliestDepartureTime);
        }
        return Optional.of(new DirectFlexPath(timeShift, finalState));
    }

    protected boolean isRouteable(FlexAccessTemplate accessTemplate, Vertex flexVertex) {
        if (accessTemplate.accessEgress.state.getVertex() == flexVertex) {
            return false;
        }
        return accessTemplate.calculator.calculateFlexPath(accessTemplate.accessEgress.state.getVertex(), flexVertex, accessTemplate.boardStopPosition, accessTemplate.alightStopPosition) != null;
    }

    private static /* synthetic */ void lambda$calculateDirectFlexPaths$0(Multimap streetEgressByStop, NearbyStop it) {
        streetEgressByStop.put((Object)it.stop, (Object)it);
    }
}

