/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.flex.FlexPathDurations;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.AbstractFlexTemplate;
import org.opentripplanner.ext.flex.template.FlexAccessEgressCallbackAdapter;
import org.opentripplanner.ext.flex.template.FlexServiceDate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;

class FlexAccessTemplate
extends AbstractFlexTemplate {
    FlexAccessTemplate(FlexTrip<?, ?> trip, NearbyStop boardStop, int boardStopPosition, StopLocation alightStop, int alightStopPosition, FlexServiceDate date, FlexPathCalculator calculator, Duration maxTransferDuration) {
        super(trip, boardStop, alightStop, boardStopPosition, alightStopPosition, date, calculator, maxTransferDuration);
    }

    @Override
    protected List<Edge> getTransferEdges(PathTransfer transfer) {
        return transfer.getEdges();
    }

    @Override
    protected RegularStop getFinalStop(PathTransfer transfer) {
        return transfer.to instanceof RegularStop ? (RegularStop)transfer.to : null;
    }

    @Override
    protected Collection<PathTransfer> getTransfersFromTransferStop(FlexAccessEgressCallbackAdapter callback) {
        return callback.getTransfersFromStop(this.transferStop);
    }

    @Override
    protected Vertex getFlexVertex(Edge edge) {
        return edge.getFromVertex();
    }

    @Override
    protected FlexPathDurations calculateFlexPathDurations(FlexTripEdge flexEdge, State state) {
        int preFlexTime = (int)this.accessEgress.state.getElapsedTimeSeconds();
        int edgeTimeInSeconds = flexEdge.getTimeInSeconds();
        int postFlexTime = (int)state.getElapsedTimeSeconds() - preFlexTime - edgeTimeInSeconds;
        return new FlexPathDurations(preFlexTime, edgeTimeInSeconds, postFlexTime, this.secondsFromStartOfTime);
    }

    @Override
    protected FlexTripEdge getFlexEdge(Vertex flexToVertex, StopLocation transferStop) {
        FlexPath flexPath = this.calculator.calculateFlexPath(this.accessEgress.state.getVertex(), flexToVertex, this.boardStopPosition, this.alightStopPosition);
        if (flexPath == null) {
            return null;
        }
        return new FlexTripEdge(this.accessEgress.state.getVertex(), flexToVertex, this.accessEgress.stop, transferStop, this.trip, this.boardStopPosition, this.alightStopPosition, this.serviceDate, flexPath);
    }
}

