/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opentripplanner.ext.flex.template.FlexAccessEgressCallbackAdapter;
import org.opentripplanner.ext.flex.template.FlexServiceDate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.transit.model.filter.expr.Matcher;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.booking.RoutingBookingInfo;
import org.opentripplanner.utils.lang.IntUtils;

record ClosestTrip(NearbyStop nearbyStop, FlexTrip<?, ?> flexTrip, int stopPos, FlexServiceDate activeDate) {
    private final FlexServiceDate activeDate;

    ClosestTrip(NearbyStop nearbyStop, FlexTrip<?, ?> flexTrip, int stopPos, FlexServiceDate activeDate) {
        this.nearbyStop = Objects.requireNonNull(nearbyStop);
        this.flexTrip = Objects.requireNonNull(flexTrip);
        this.stopPos = IntUtils.requireNotNegative((int)stopPos, (String)"stopPos");
        this.activeDate = activeDate;
    }

    private ClosestTrip(NearbyStop nearbyStop, FlexTrip<?, ?> flexTrip, int stopPos) {
        this(nearbyStop, flexTrip, stopPos, null);
    }

    private ClosestTrip(ClosestTrip original, FlexServiceDate activeDate) {
        this(original.nearbyStop, original.flexTrip, original.stopPos, activeDate);
    }

    static Collection<ClosestTrip> of(FlexAccessEgressCallbackAdapter callbackService, Collection<NearbyStop> nearbyStops, Matcher<Trip> matcher, List<FlexServiceDate> dates, boolean pickup) {
        Map<FlexTrip<?, ?>, ClosestTrip> closestTrips = ClosestTrip.findAllTripsReachableFromNearbyStop(callbackService, nearbyStops, matcher, pickup);
        return ClosestTrip.findActiveDatesForTripAndDecorateResult(callbackService, dates, closestTrips, true);
    }

    public FlexServiceDate activeDate() {
        return Objects.requireNonNull(this.activeDate);
    }

    private static Map<FlexTrip<?, ?>, ClosestTrip> findAllTripsReachableFromNearbyStop(FlexAccessEgressCallbackAdapter callbackService, Collection<NearbyStop> nearbyStops, Matcher<Trip> matcher, boolean pickup) {
        HashMap map = new HashMap();
        for (NearbyStop nearbyStop : nearbyStops) {
            StopLocation stop = nearbyStop.stop;
            for (FlexTrip<?, ?> trip : callbackService.getFlexTripsByStop(stop)) {
                ClosestTrip existing;
                int stopPos = pickup ? trip.findBoardIndex(stop) : trip.findAlightIndex(stop);
                if (stopPos == FlexTrip.STOP_INDEX_NOT_FOUND || !matcher.match(trip.getTrip()) || (existing = map.get(trip)) != null && !nearbyStop.isBetter(existing.nearbyStop())) continue;
                map.put(trip, new ClosestTrip(nearbyStop, trip, stopPos));
            }
        }
        return map;
    }

    private static ArrayList<ClosestTrip> findActiveDatesForTripAndDecorateResult(FlexAccessEgressCallbackAdapter callbackService, List<FlexServiceDate> dates, Map<FlexTrip<?, ?>, ClosestTrip> map, boolean pickup) {
        ArrayList<ClosestTrip> result = new ArrayList<ClosestTrip>();
        for (Map.Entry<FlexTrip<?, ?>, ClosestTrip> e : map.entrySet()) {
            FlexTrip<?, ?> trip = e.getKey();
            ClosestTrip closestTrip = e.getValue();
            for (FlexServiceDate date : dates) {
                if (pickup && ClosestTrip.exceedsLatestBookingTime(trip, date, closestTrip.stopPos()) || !callbackService.isDateActive(date, trip)) continue;
                result.add(closestTrip.withDate(date));
            }
        }
        return result;
    }

    private ClosestTrip withDate(FlexServiceDate date) {
        Objects.requireNonNull(date);
        return new ClosestTrip(this, date);
    }

    private static boolean exceedsLatestBookingTime(FlexTrip<?, ?> trip, FlexServiceDate date, int stopPos) {
        return RoutingBookingInfo.of(date.requestedBookingTime(), trip.getPickupBookingInfo(stopPos)).exceedsLatestBookingTime();
    }
}

