/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.ext.flex.FlexPathDurations;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessEgressCallbackAdapter;
import org.opentripplanner.ext.flex.template.FlexServiceDate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.EdgeTraverser;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.utils.tostring.ToStringBuilder;

abstract class AbstractFlexTemplate {
    private static final int MIN_FLEX_TRIP_DURATION_SECONDS = 10;
    protected final NearbyStop accessEgress;
    protected final FlexTrip<?, ?> trip;
    protected final int boardStopPosition;
    protected final int alightStopPosition;
    protected final StopLocation transferStop;
    protected final int secondsFromStartOfTime;
    protected final LocalDate serviceDate;
    protected final int requestedBookingTime;
    protected final FlexPathCalculator calculator;
    private final Duration maxTransferDuration;

    AbstractFlexTemplate(FlexTrip<?, ?> trip, NearbyStop accessEgress, StopLocation transferStop, int boardStopPosition, int alightStopPosition, FlexServiceDate date, FlexPathCalculator calculator, Duration maxTransferDuration) {
        this.accessEgress = accessEgress;
        this.trip = trip;
        this.boardStopPosition = boardStopPosition;
        this.alightStopPosition = alightStopPosition;
        this.transferStop = transferStop;
        this.secondsFromStartOfTime = date.secondsFromStartOfTime();
        this.serviceDate = date.serviceDate();
        this.requestedBookingTime = date.requestedBookingTime();
        this.calculator = calculator;
        this.maxTransferDuration = maxTransferDuration;
    }

    StopLocation getTransferStop() {
        return this.transferStop;
    }

    StopLocation getAccessEgressStop() {
        return this.accessEgress.stop;
    }

    Stream<FlexAccessEgress> createFlexAccessEgressStream(FlexAccessEgressCallbackAdapter callback) {
        StopLocation stopLocation = this.transferStop;
        if (stopLocation instanceof RegularStop) {
            RegularStop stop = (RegularStop)stopLocation;
            TransitStopVertex flexVertex = callback.getStopVertex(stop.getId());
            return Stream.of(this.createFlexAccessEgress(new ArrayList<Edge>(), flexVertex, stop)).filter(Objects::nonNull);
        }
        double maxDistanceMeters = (double)this.maxTransferDuration.getSeconds() * this.accessEgress.state.getRequest().preferences().walk().speed();
        return this.getTransfersFromTransferStop(callback).stream().filter(pathTransfer -> pathTransfer.getDistanceMeters() <= maxDistanceMeters).filter(transfer -> this.getFinalStop((PathTransfer)transfer) != null).map(transfer -> {
            List<Edge> edges = this.getTransferEdges((PathTransfer)transfer);
            Vertex flexVertex = this.getFlexVertex(edges.get(0));
            RegularStop finalStop = this.getFinalStop((PathTransfer)transfer);
            return this.createFlexAccessEgress(edges, flexVertex, finalStop);
        }).filter(Objects::nonNull);
    }

    public String toString() {
        return ToStringBuilder.of(AbstractFlexTemplate.class).addObj("accessEgress", (Object)this.accessEgress).addObj("trip", this.trip).addNum("boardStopPosition", (Number)this.boardStopPosition).addNum("alightStopPosition", (Number)this.alightStopPosition).addObj("transferStop", (Object)this.transferStop).addServiceTime("secondsFromStartOfTime", this.secondsFromStartOfTime).addDate("serviceDate", this.serviceDate).addObj("calculator", (Object)this.calculator).addDuration("maxTransferDuration", this.maxTransferDuration).toString();
    }

    protected abstract List<Edge> getTransferEdges(PathTransfer var1);

    protected abstract RegularStop getFinalStop(PathTransfer var1);

    protected abstract Collection<PathTransfer> getTransfersFromTransferStop(FlexAccessEgressCallbackAdapter var1);

    protected abstract Vertex getFlexVertex(Edge var1);

    protected abstract FlexPathDurations calculateFlexPathDurations(FlexTripEdge var1, State var2);

    @Nullable
    protected abstract FlexTripEdge getFlexEdge(Vertex var1, StopLocation var2);

    @Nullable
    private FlexAccessEgress createFlexAccessEgress(List<Edge> transferEdges, Vertex flexVertex, RegularStop stop) {
        FlexTripEdge flexEdge = this.getFlexEdge(flexVertex, this.transferStop);
        if (flexEdge == null || flexEdge.getTimeInSeconds() < 10) {
            return null;
        }
        State[] afterFlexState = flexEdge.traverse(this.accessEgress.state);
        if (State.isEmpty(afterFlexState)) {
            return null;
        }
        Optional<State> finalStateOpt = EdgeTraverser.traverseEdges(afterFlexState[0], transferEdges);
        return finalStateOpt.map(finalState -> {
            FlexPathDurations durations = this.calculateFlexPathDurations(flexEdge, (State)finalState);
            return new FlexAccessEgress(stop, durations, this.boardStopPosition, this.alightStopPosition, this.trip, (State)finalState, transferEdges.isEmpty(), this.requestedBookingTime);
        }).orElse(null);
    }
}

