/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.flexpathcalculator;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.astar.strategy.DurationSkipEdgeStrategy;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.strategy.DominanceFunctions;

public class StreetFlexPathCalculator
implements FlexPathCalculator {
    private final Map<Vertex, ShortestPathTree<State, Edge, Vertex>> cache = new HashMap<Vertex, ShortestPathTree<State, Edge, Vertex>>();
    private final boolean reverseDirection;
    private final Duration maxFlexTripDuration;

    public StreetFlexPathCalculator(boolean reverseDirection, Duration maxFlexTripDuration) {
        this.reverseDirection = reverseDirection;
        this.maxFlexTripDuration = maxFlexTripDuration;
    }

    @Override
    public FlexPath calculateFlexPath(Vertex fromv, Vertex tov, int boardStopPosition, int alightStopPosition) {
        ShortestPathTree<State, Edge, Vertex> shortestPathTree;
        Vertex destinationVertex;
        Vertex originVertex = this.reverseDirection ? tov : fromv;
        Vertex vertex = destinationVertex = this.reverseDirection ? fromv : tov;
        if (this.cache.containsKey(originVertex)) {
            shortestPathTree = this.cache.get(originVertex);
        } else {
            shortestPathTree = this.routeToMany(originVertex);
            this.cache.put(originVertex, shortestPathTree);
        }
        GraphPath<State, Edge, Vertex> path = shortestPathTree.getPath(destinationVertex);
        if (path == null) {
            return null;
        }
        int distance = (int)path.edges.stream().mapToDouble(Edge::getDistanceMeters).sum();
        int duration = path.getDuration();
        return new FlexPath(distance, duration, () -> GeometryUtils.concatenateLineStrings(path.edges, Edge::getGeometry));
    }

    private ShortestPathTree<State, Edge, Vertex> routeToMany(Vertex vertex) {
        RouteRequest routingRequest = RouteRequest.of().withArriveBy(this.reverseDirection).buildDefault();
        return ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setSkipEdgeStrategy(new DurationSkipEdgeStrategy(this.maxFlexTripDuration))).setDominanceFunction(new DominanceFunctions.EarliestArrival())).setRequest(routingRequest).setStreetRequest(new StreetRequest(StreetMode.CAR)).setFrom(this.reverseDirection ? null : vertex)).setTo(this.reverseDirection ? vertex : null)).getShortestPathTree();
    }
}

