/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.flexpathcalculator;

import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.street.model.vertex.Vertex;

public class ScheduledFlexPathCalculator
implements FlexPathCalculator {
    private final FlexPathCalculator flexPathCalculator;
    private final FlexTrip trip;

    public ScheduledFlexPathCalculator(FlexPathCalculator flexPathCalculator, FlexTrip<?, ?> trip) {
        this.flexPathCalculator = flexPathCalculator;
        this.trip = trip;
    }

    @Override
    public FlexPath calculateFlexPath(Vertex fromv, Vertex tov, int boardStopPosition, int alightStopPosition) {
        FlexPath flexPath = this.flexPathCalculator.calculateFlexPath(fromv, tov, boardStopPosition, alightStopPosition);
        if (flexPath == null) {
            return null;
        }
        int departureTime = this.trip.earliestDepartureTime(Integer.MIN_VALUE, boardStopPosition, alightStopPosition, 0);
        if (departureTime == -999) {
            return null;
        }
        int arrivalTime = this.trip.latestArrivalTime(Integer.MAX_VALUE, boardStopPosition, alightStopPosition, 0);
        if (arrivalTime == -999) {
            return null;
        }
        if (departureTime >= arrivalTime) {
            return null;
        }
        return new FlexPath(flexPath.distanceMeters, arrivalTime - departureTime, flexPath::getGeometry);
    }
}

